﻿#---------------------------------
#Google Chrome Extensions in User Profiles, Name and Version
#version 0.1 Created 3/28/2016 Sherry Kissinger
#version 0.2 Modified 3/29/2016 Sherry Kissinger (added Folder Date/Time Stamp)
#version 0.3 Modified 3/29/2016 Sherry Kissinger (Optionally Exclude Unknown and Common Extensions)
#In response to https://social.technet.microsoft.com/Forums/systemcenter/en-US/55b1d256-f3fb-4296-a9e6-2241cc8d4d0d/sccm-report-google-chrome-extensions?forum=configmanagergeneral
#CAUTION  :  this was written in a lab with ONE and only ONE test box.
#  I promise this script is useless and won't work at all... unless it just so happens to actually work.
#  In other words, it's up to YOU to test it and see if it does what you think you want it to do.
#  It might be the absolutely worst thing ever.  No support is provided, and no help is available if it happens
#  to be useless or happens to blow up your environment.
#  the script was also cobbled together in a hurry while the original creator was doing other things.
#  There is probably a dozen different and better ways to get to the results--but this worked, so hey, done!
#  Feel free to re-write, re-do, modify, update, do whatever might make this script better/faster/cooler...
#   As long as the end result is still FREE to everyone to use and you keep the original credits, and
#   DOCUMENT in-script; exactly what you changed, how, and why.
#---------------------------------
#Steps:
#1. Find where user profile files are stored on the system
#2. Determine which user profiles have a folder called "\appdata\local\google\chrome\user data\default\extensions"
#3.  For each user profile with that folder...
#4.   For each subfolder...
#5.    Inside each subfolder, read the manifest.json file
#6.      Inside manifest.json file, record what's after "version":  and what's after "Name":
#7.      if "Name" : = "__MSG_APP_NAME__" then look in a different file for language specific name
#8.        Loop though the subfolders until first 1 is found at all, then read that message.json until you get app_name
#9.     else continue; you have name and version.
#10.     (keep track of name and version)
#11.   Move on to next subfolder
#12.   Clear, create, and save the data into a custom WMI namespace.

$ErrorActionPreference = "SilentlyContinue"
$ExcludeCommonExtensions = 'True'  #optional, if you want to exclude the following common extensions.
                                   #if you want to report on all the below, either change the 'True' to anything other than 'True' 
                                   #OR  modify the line below to not exclude 1 or multiple listings
$CommonExtensions = 'Google Docs','Google Sheets','Google Slides','Unknown','Google Drive','YouTube','Gmail'

#FUNCTION to create data class structure for Data

function Create-Wmi-Class()
{
$newClass = New-Object System.Management.ManagementClass("root\cimv2", [String]::Empty, $null); 

$newClass["__CLASS"] = "cm_ChromeExtensions";

$newClass.Qualifiers.Add("Static", $true)
$newClass.Properties.add("Counter", [System.Management.CimType]::UInt32, $false)
$newClass.Properties.add("ProfilePath", [System.Management.CimType]::String, $false)
$newClass.Properties.add("FolderDate", [System.Management.CimType]::DateTime, $false)
$newClass.Properties.add("Name", [System.Management.CimType]::String, $false)
$newClass.Properties.add("Version", [System.Management.CimType]::String, $false)
$newClass.Properties.add("ScriptLastRan", [System.Management.CimType]::String, $false)
$newClass.Properties["Counter"].Qualifiers.Add("Key", $true)
$newClass.Put()
}

# Check whether we already created our custom WMI class on this PC, if not, create it
[void](Get-WMIObject cm_ChromeExtensions -ErrorAction SilentlyContinue -ErrorVariable wmiclasserror)

if ($wmiclasserror)
{
    try { Create-Wmi-Class }
    catch
    {
        "Could not create WMI class"
        Exit 1
    }
}

#*********************************************
# Clear WMI
Get-WmiObject cm_ChromeExtensions | Remove-WmiObject
$j = 0
#=============================================
#Done reading or clearing the WMI Class, let's read text files.  
#lovely, lovely text files. obnoxiously lovely text files

#----------------------------------
#1. Find where user profile files are stored on the system
#----------------------------------
$path = 'Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\ProfileList\*'
$ProfilePath = Get-ItemProperty -Path $path | Select-Object -Property ProfileImagePath
$ProfilePath | Foreach-object {
#----------------------------------
#2. Determine which user profiles have a folder called "\appdata\local\google\chrome\user data\default\extensions"
#----------------------------------
 if (test-path ($_.profileimagepath + "\appdata\local\google\chrome\user data\default\extensions")) 
  {
#----------------------------------
#3.  For each user profile with that folder...
#4.   For each subfolder...
#----------------------------------
#  Get the Date of each Folder
   $ChromeProfileFolder = Get-ChildItem ($_.profileimagepath + "\appdata\local\google\chrome\user data\default\extensions") | ? { $_.PSIsContainer} # | Select-Object FullName, LastWriteTime
   ForEach ($CPF in $ChromeProfileFolder) {
   $FolderDate = Get-ChildItem $cpf.fullname | select-object -last 1 | ForEach-Object { ($_.lastwritetime.tostring("yyyyMMddhhmmss"))+ '.000000-000'  } 
#--------------------
#Get UserProfilePath
#--------------------
   $UserPath,$Leftovers = $cpf.fullname -split('appdata')
#----------------------------------
#5.    Inside each subfolder, read the manifest.json file
#----------------------------------
   $ManifestFile = (gci -path $cpf.fullName -filter manifest.json -Recurse).FullName
   $ManifestFileFolder = (gci -path $cpf.fullName -filter manifest.json -Recurse).DirectoryName
   if (test-path $ManifestFile) {
#----------------------------------
#6.      Inside manifest.json file, record what's after "version":  and what's after "Name":
#----------------------------------
   $Version = (Get-Content $ManifestFile | Where-Object {$_ -like '*"version":*'}) | foreach {
   #Trim the Value of any spaces, commas, and double-quotes
   $Label1,$Value1 = $_.split(':').trim().trim([Char]0x002C).trim([Char]0x0022)
   }
   #Value1 will be the version of the extension
#   write-host $Value1 
   $Name = (Get-Content $ManifestFile | Where-Object {$_ -like '*"name":*'})  | foreach {
   #Trim the Value of any spaces, commas, and double-quotes
   $Label2,$Value2 = $_.split(':').trim().trim([Char]0x002C).trim([Char]0x0022)
#----------------------------------
#7.      if "Name" : = "__MSG_APP_NAME__" then look in a different file for language specific name
#----------------------------------
   $NameToRecord = $Value2
   if ($value2 -like "__*") {
   Remove-Variable -Name $EnglishMessages
   Remove-Variable -Name $EnglishMessages2
     $EnglishMessages = (gci -path ($ManifestFileFolder + "\_locales\en") -filter messages.json -Recurse).FullName 
     $EnglishMessages2 = (gci -path ($ManifestFileFolder + "\_locales\en_US") -filter messages.json -Recurse).FullName
#----------------------------------
#8.        Loop though the subfolders until first 1 is found at all, then read that message.json until you get app_name
#----------------------------------
   if (test-path $EnglishMessages) {
      $label3 = ""
      $label4 = ""
      $label5 = ""
      $indx1NextLine = ""
      $indx2NextLine2 = ""
      $indx3NextLine3 = ""
      $indx = ""
      $indx2 = ""
      $indx3 = ""

      $indx = Select-String 'app_name' $EnglishMessages | ForEach-Object {$_.LineNumber}
      $indx1NextLine = (Get-Content $EnglishMessages)[$indx]
      $Label3,$Value3 = $indx1NextLine.split(':').trim().trim([Char]0x002C).trim([Char]0x0022)
      $indx2 = Select-String 'appName' $EnglishMessages | ForEach-Object {$_.LineNumber}
      $indx2NextLine2 = (Get-Content $EnglishMessages)[$indx2]
      $Label4,$Value4 = $indx2NextLine2.split(':').trim().trim([Char]0x002C).trim([Char]0x0022)
      $indx3 = Select-String 'app Name' $EnglishMessages | ForEach-Object {$_.LineNumber}
      $indx3NextLine3 = (Get-Content $EnglishMessages)[$indx3]
      $Label5,$Value5 = $indx3NextLine3.split(':').trim().trim([Char]0x002C).trim([Char]0x0022)
      if ($label3.trim() -eq "message") { $NameToRecord = $Value3 } else {$NameToRecord = ""}
      if ($label4.Trim() -eq "message") { $NameToRecord = $Value4} else {$NameToRecord = ""}
      if ($label5.Trim() -eq "message") { $NameToRecord = $Value5} else {$NameToRecord = ""}
      if ($NameToRecord -eq "") { $NameToRecord = "Unknown"}
       }  #EnglishMessages

   if (($NameToRecord -like '__*') -and (test-path $EnglishMessages2)) {
      $label3 = ""
      $label4 = ""
      $label5 = ""
      $indx1NextLine = ""
      $indx2NextLine2 = ""
      $indx3NextLine3 = ""
      $indx = ""
      $indx2 = ""
      $indx3 = ""

      $indx = Select-String 'app_name' $EnglishMessages2 | ForEach-Object {$_.LineNumber}
      $indx1NextLine = (Get-Content $EnglishMessages2)[$indx]
      $Label3,$Value3 = $indx1NextLine.split(':').trim().trim([Char]0x002C).trim([Char]0x0022)
      $indx2 = Select-String 'appName' $EnglishMessages2 | ForEach-Object {$_.LineNumber}
      $indx2NextLine2 = (Get-Content $EnglishMessages2)[$indx2]
      $Label4,$Value4 = $indx2NextLine2.split(':').trim().trim([Char]0x002C).trim([Char]0x0022)
      $indx3 = Select-String 'app Name' $EnglishMessages2 | ForEach-Object {$_.LineNumber}
      $indx3NextLine3 = (Get-Content $EnglishMessages2)[$indx3]
      $Label5,$Value5 = $indx3NextLine3.split(':').trim().trim([Char]0x002C).trim([Char]0x0022)
      if ($label3.trim() -eq "message") { $NameToRecord = $Value3 } else {$NameToRecord = ""}
      if ($label4.Trim() -eq "message") { $NameToRecord = $Value4} else {$NameToRecord = ""}
      if ($label5.Trim() -eq "message") { $NameToRecord = $Value5} else {$NameToRecord = ""}
      if ($NameToRecord -eq "") { $NameToRecord = "Unknown"}
       } #EnglishMessages2

    } #__something for a name 
#================
#12.   Clear, create, and save the data into a custom WMI namespace.
#================
   #If we were able to parse it out, $NametoRecord will be the englishy name of the extension
#    write-host $NameToRecord
   #Value1 will be the version of the extension
#   write-host $Value1 

If ($ExcludeCommonExtensions -eq 'True') {
    if ($CommonExtensions -match $NameToRecord) {
    #Skip adding common extensions
    }
    Else {
    (Set-WmiInstance -Path \\.\root\cimv2:cm_ChromeExtensions  -Arguments @{
        Counter=$j;
        Name=$NameToRecord;
        ProfilePath=$Userpath;
        FolderDate=$FolderDate;
        Version=$Value1;
        ScriptLastRan=Get-Date})
          $j=$j+1
         }
         
    }


If ($ExcludeCommonExtensions -ne 'True') {
(Set-WmiInstance -Path \\.\root\cimv2:cm_ChromeExtensions  -Arguments @{
    Counter=$j;
    Name=$NameToRecord;
    ProfilePath=$Userpath;
    FolderDate=$FolderDate;
    Version=$Value1;
    ScriptLastRan=Get-Date})
         $j=$j+1
}

   }#If we found a manifestfile at all in a folder
   }#foreach chrome profile folder
  }#if we found a folder in the user profiles with a likely looking chrome extensions folder


  } #close of each profile with chrome extensions
} #close for each profilepath
#====================
#And we're all done here.  For use with ConfigMgr, you'll want to extend inventory to query
#the root\cimv2\cm_ChromeExtensions class and attributes.