#CM12 SP1 Server 2K8 R2 Prerequisites Install
# Ver 1.8.2k8R2
#By: Jeff Carreon
#Updated: 10/29/2012
#QA-ENT - LAB
#---------###----------#
#-Installs all CM12 SP1 Prerequisites depending on the role chosen at the prompt
#-For servers with IIS; Moves IIS to D, Configures all CCMPENG standard IIS settings, Creates IISLogs$ Share
#-Opens up necessary firewalls (1433/4022 for MPs/DPs and 1433 for SUPs. 1433, 4022, and WMI for Primary)
#-For Primary servers - Copy then Install .NET 4, and WSUS 3.0 SP2 Console
#-For SUPs Prereqs; Installs .NET 4
#-Drops nosmsdrive on root
#-Added support for ADK components; USMT, Windows Deployment Tool, WinPE
#-For SUPs Post SQL Install; Installs WSUS and Configures IIS Logs Settings (SQL IS REQUIRED); Installs KB272021, and KB2734608
#-1.6 version, added logging. Log is created where the ps1 is being run, locally.
#-1.7 - added individual SQL Install for Top SUP
#-1.8 - added enabling of Windows Auth for MP.  Added ConfigMgr Replica share, ConfigMgr_ReplicaAccess group creation for Primary servers.  And CAS support
#
# ******* PAY CLOSE ATTENTION TO THE VARIABLES BELOW. CHANGE THEM ACCORDINGLY. ******
# ******* AND MAKE SURE THOSE FILES AND FOLDERS EXIST IN THE $Location\Storage$ SHARE, ALONG WITH INI FILES FOR SQL ******


##################################### Setting Variables #######################################
$strDomain = "QA-ENT"
$SLocation = "SDESLABCM05.ent.wfb.bank.qa"
$strScriptName = "CM12SP1-R2PreReqQA-1-8.ps1"
$strScriptVersion = "1.8.2k8R2"

$strNetLocation = "\\$SLocation\storage$\CM12\Updates\dotNetFx40_Full_x86_x64.exe"
$strWSUSLocation = "\\$SLocation\storage$\WSUS\WSUS30-KB972455-x64.exe"
$strWSUSKB2720211Location = "\\$SLocation\storage$\WSUS\SUPKBs\WSUS-KB2720211-x64.exe"
$strWSUSKB2734608Location = "\\$SLocation\storage$\WSUS\SUPKBs\WSUS-KB2734608-x64.exe"
$strADKLocation = "\\$SLocation\storage$\CM12\3ADK\*.*"
$DOTNETexe = "D:\Storage\DOTNET\dotNetFx40_Full_x86_x64.exe"
$strSQL12Location = "\\$SLocation\storage$\SQL\12\SQL12STD\*"
$strSQL12Setup = "D:\Storage\SQL12STD\Setup.exe"
$strsQL12ENTLocation = "\\$SLocation\storage$\SQL\12\SQL12ENT\*"
$strSQL12ENTSetup = "D:\Storage\SQL12ENT\Setup.exe"
$strSQL12MPParam = "/ConfigurationFile=D:\Storage\SQL12STD\MPConfigurationFile.ini"
$strSQL12SUPParam = "/ConfigurationFile=D:\Storage\SQL12STD\SUPConfigurationFile.ini"
$strSQL12TopSUPParam = "/ConfigurationFile=D:\Storage\SQL12STD\TOPSUPConfigurationFile.ini"
$strSQL12PParam = "/ConfigurationFile=D:\Storage\SQL12ENT\PConfigurationFile.ini"
$WSUSexe = "D:\Storage\WSUS\WSUS30-KB972455-x64.exe"
$WSUSKB2720211exe = "D:\Storage\WSUS\WSUS-KB2720211-x64.exe"
$WSUSKB2734608exe = "D:\Storage\WSUS\WSUS-KB2734608-x64.exe"
$WSUSCparam = "CONSOLE_INSTALL=1"
$WSUSSparam1 = "CONTENT_LOCAL=1"
$WSUSSparam2 = "CONTENT_DIR=D:\WSUS"
$WSUSSparam3 = "DEFAULT_WEBSITE=0"
$WSUSSparam4 = "CREATE_DATABASE=1"
$WSUSSparam5 = "SQLINSTANCE_NAME=%COMPUTERNAME%"
$strDateRunTime = (Get-Date)
$ErrorActionPreference= 'silentlycontinue'


##################################### Declaring Functions #######################################



Function LogWrite([string]$info){
	if($loginitialized -eq $false)
		{
		$FileHeader > $logfile
		$script:loginitialized = $True
		}
	$info >> $logfile
}    


Function CheckOS{
		$strOS = [System.Environment]::OSVersion.VersionString
		IF ($strOS -like "Microsoft Windows NT 6.1.7601 Service Pack 1")
		    {
		    Write-Host "OS is Microsoft Windows Server 2008 R2 with SP1..."
			Write-Host "Proceeding with the install..."
			Start-Sleep -Seconds 3
		    }
		Else
		{
		    Write-Host "OS is Not valid. This script is only for Server 2K8 R2..." -ForegroundColor Red -BackgroundColor Black
			Write-Host "Please run the Server 2012 Version of this script... Exiting..." -ForegroundColor Red -BackgroundColor Black
			Start-Sleep -Seconds 5
			Exit
		}

}

Function CreateStorage{
		If (!(Test-Path -path D:\Storage\))
		      
			 {
			  New-Item D:\Storage\ -type directory
			 }

		}


Function CountDown{
				Write-Host -noNewLine "Installing $AppDesc please wait." -foregroundcolor Yellow
				do {
				  for ($i=0;$i -le 50; $i++)
					{if ($i -lt 50)
						{Write-Host -noNewLine "." -foregroundcolor Yellow
						Start-Sleep -m 50}
					}
					}
				While (get-process $Monexe -ErrorAction SilentlyContinue | select -Property Responding)

				$strTime = get-date
				Write-Host "$AppDesc Installion is completed on: $strTime"
}

Function CreateCmMPReplica{
			
	    $a="no error"
	    Try
			{				
				
				If (!(Test-Path -path S:\ConfigMgr_MPReplica\))
				     {
					  Write-Host "Creating ConfigMgr_MPReplica folder..." -ForegroundColor Yellow
					  LogWrite "Creating ConfigMgr_MPReplica folder..."
					  New-Item S:\ConfigMgr_MPReplica\ -type directory

					 }
				Else
					{
					  Write-Host "Folder already created..." -ForegroundColor Yellow
					  LogWrite "Folder already created..."
					 
					}
    			  Write-Host "Creating ConfigMgr_MPReplica folder... COMPLETED" -ForegroundColor Green
				  LogWrite "Creating ConfigMgr_MPReplica folder... COMPLETED"

			}
		Catch [system.exception]
			 {
				 Write-host "Error Creating the folder! " -ForegroundColor Red -BackgroundColor Black
				 LogWrite "Error Creating the folder! "
				 #$error
				 $a = "error"
				 
			 }
}

Function CreateCmMPReplicaGroup{

	    $a="no error"
	    Try
			{

				Write-Host "Creating ConfigMgr_MPReplicaAccess group..." -ForegroundColor Yellow
				LogWrite "Creating ConfigMgr_MPReplicaAccess group...."
				$computerName = "."
				$localGroupName = "ConfigMgr_MPReplicaAccess"
				$description = "ConfigMgr MP Replica Access Group"
				  
				If ($computerName -eq "") {$computerName = "$env:computername"}  
				  
				If([ADSI]::Exists("WinNT://$computerName,computer")) {  
				  
				    $computer = [ADSI]"WinNT://$computerName,computer"  
				  
				    $localGroup = $computer.Create("group",$localGroupName)  
				    $localGroup.SetInfo()  
				    $localGroup.description = [string]$description  
				    $localGroup.SetInfo()  
				} 
				Write-Host "Creating ConfigMgr_MPReplicaAccess group... COMPLETED" -ForegroundColor Green
				LogWrite "Creating ConfigMgr_MPReplicaAccess group.... COMPLETED"

			}
		Catch [system.exception]
			 {
				 Write-host "Error Creating the group! " -ForegroundColor Red -BackgroundColor Black
				 LogWrite "Error Creating the group! "
				 #$error
				 $a = "error"
				 
			 }



}





Function InstallDOTNET{
		$AppDesc = ".NET 4 Framework"
		$Monexe = "dotNetFx40_Full_x86_x64"
		If (!(Test-Path -path D:\Storage\DOTNET\))
		      
			 {
			  New-Item D:\Storage\DOTNET\ -type directory
			  Write-Host "Copying .NET 4 Framework..." -ForegroundColor Yellow
			  copy-item -Path $strNetLocation -Destination 'D:\storage\DOTNET'
			  LogWrite "Installing .NET 4.0...."
			  & $DOTNETexe /q /norestart
			  CountDown{}
			  LogWrite "Installing .NET 4.0.... COMPLETED"
			 }
		ELSE
			{
			 $ChkFile = "D:\Storage\DOTNET\dotNetFx40_Full_x86_x64.exe" 
			 $FileExists = (Test-Path $ChkFile -PathType Leaf)
			 If (!($FileExists)) 
				{
				    Write-Host "Copying .NET 4 Framework..." -ForegroundColor Yellow
				    copy-item -Path $strNetLocation -Destination 'D:\storage\DOTNET'
					LogWrite "Installing .NET 4.0...."
				    & $DOTNETexe /q /norestart
					CountDown{}
					LogWrite "Installing .NET 4.0.... COMPLETED"
					
				}
				ElseIf ($FileExists)
				{
				    LogWrite "Installing .NET 4.0...."
					& $DOTNETexe /q /norestart
					CountDown{}
					LogWrite "Installing .NET 4.0.... COMPLETED"
				}
			}
		}

Function CopyWSUSCode{
			  Write-Host "Copying WSUS 3.0 SP2 Install..." -ForegroundColor Yellow
			  copy-item -Path $strWSUSLocation -Destination 'D:\storage\WSUS'
			  copy-Item -Path $strWSUSKB2720211Location -Destination 'D:\storage\WSUS'
			  copy-Item -Path $strWSUSKB2734608Location -Destination 'D:\storage\WSUS'
		}	  

Function PrepWSUS{
		$AppDesc = "WSUS 3.0 SP2 Console"
		$Monexe = "WSUS30-KB972455-x64"
		If (!(Test-Path -path D:\Storage\WSUS\))
		      
			 {
			  New-Item D:\Storage\WSUS\ -type directory
			  CopyWSUSCode{}
			  If ($ConfirmRole -like "P")
			  	{
					LogWrite "Installing WSUS Console...."
					& $WSUSexe /q $WSUSCparam
					CountDown{}
					LogWrite "Installing WSUS Console.... COMPLETED"
			  	}
			  Else {Write-Host "Copy is finished. Install WSUS manually from D:\Storage\WSUS folder..." -ForegroundColor Yellow}
			 }
		ELSE
			{
			 $ChkFile = "D:\Storage\WSUS\WSUS30-KB972455-x64.exe" 
			 $FileExists = (Test-Path $ChkFile -PathType Leaf)
			 If (!($FileExists)) 
				{
			  			CopyWSUSCode{}
						If ($ConfirmRole -like "P")
						  	{
								LogWrite "Installing WSUS Console...."
								& $WSUSexe /q $WSUSCparam
								CountDown{}
								LogWrite "Installing WSUS Console.... COMPLETED"
						  	}
					
				}
				ElseIf ($FileExists)
				{
						If ($ConfirmRole -like "P")
						  	{
								LogWrite "Installing WSUS Console...."
								& $WSUSexe /q $WSUSCparam
								CountDown{}
								LogWrite "Installing WSUS Console.... COMPLETED"
						  	}
				}
			}
		}

Function MoveIIS{
		
		If (!(Test-Path -path D:\IIS\wwwroot\))
			{
				Write-Host "Configuring IIS settings..." -ForegroundColor Yellow
				Write-Host "Stopping IIS..." -ForegroundColor Yellow
				
				IIsreset /stop
				LogWrite "Configuring and Moving IIS to D drive..."
				New-Item D:\IIS -type directory
				Copy-Item C:\inetpub\* D:\IIS -recurse
				Import-Module WebAdministration
				
				Set-ItemProperty 'IIS:\Sites\Default Web Site' -name physicalPath -value "D:\IIS\wwwroot"
				Set-ItemProperty 'IIS:\Sites\Default Web Site' -name logfile.directory "D:\IIS\Logs"
				Set-ItemProperty 'IIS:\Sites\Default Web Site' -name logfile.localTimeRollover true
				Set-ItemProperty 'IIS:\Sites\Default Web Site' -name logfile.period 0
				Set-ItemProperty 'IIS:\Sites\Default Web Site' -name logfile.truncateSize 5242880
				Write-Host "Starting IIS..." -ForegroundColor Yellow
				IIsreset /start
				LogWrite "Default IIS Configuration Completed..."
				Write-Host "Configuring IIS settings. DONE..." -ForegroundColor Green
			}
		Else
			{
				LogWrite "No need to configure, IIS was already done..."
				Write-Host "IIS is already moved..." -ForegroundColor red -BackgroundColor Black
				Start-Sleep -Seconds 5
			}
}

Function CreateShare($Foldername,$Sharename) {
#
# $Foldername - The full path to the share
# $Sharename  - The share name

  write-host "########## $Sharename ##########"

  # Check if the path exists
  IF (!(TEST-PATH $Foldername)) {
   # Create folder 
   NEW-ITEM $Foldername -type Directory
   write-host "Created $Foldername"
  }
 
  # Create Share but check to make sure it isnt already there
  If (!(GET-WMIOBJECT Win32_Share | Where-Object -FilterScript {$_.Name -eq $Sharename})) {
    # Create share
    $Shares = [wmiclass]"Win32_Share"
    $results = $Shares.Create($Foldername,$Sharename,0,$null, "IIS Logs Share")
    if ($results.returnvalue -eq "0") {
     # Share created ok
     write-host "Created $Sharename Share Successfully" -ForegroundColor Green
    } else {
     # Error creating share
     write-host "Failed to create $Sharename Share ERROR:" $results.returnvalue -ForegroundColor Red
    }
  } ELSE {
    # Share name already exists
    write-host "$Sharename already exists"  -ForegroundColor Green
  }
}

Function Create-FileShare($path,$name)
{
    #$name = $folder.Name
    #$path = $folder.FullName

	#$name = "ConfigMgr_MPReplica"
    #$path = "D:\ConfigMgr_MPReplica"
    $description = "$name"

    $Method = "Create"
    $sd = ([WMIClass] "Win32_SecurityDescriptor").CreateInstance()

    #AccessMasks:
    #2032127 = Full Control
    #1245631 = Change
    #1179817 = Read
    If ($name -eq "ConfigMgr_MPReplica")
	{
		    #Share with SYSTEM
		    $ACE = ([WMIClass] "Win32_ACE").CreateInstance()
		    $Trustee = ([WMIClass] "Win32_Trustee").CreateInstance()
		    $Trustee.Name = "SYSTEM"
		    $Trustee.Domain = $Null
		    #$Trustee.SID = ([wmi]"win32_userAccount.Domain='york.edu',Name='$name'").sid   
		    $ace.AccessMask = 2032127
		    $ace.AceFlags = 3
		    $ace.AceType = 0
		    $ACE.Trustee = $Trustee 
		    $sd.DACL += $ACE.psObject.baseobject 

		    #Share with ConfigMgr_MPReplicaAccess
		    $ACE = ([WMIClass] "Win32_ACE").CreateInstance()
		    $Trustee = ([WMIClass] "Win32_Trustee").CreateInstance()
		    $Trustee.Name = "ConfigMgr_MPReplicaAccess"
		    $Trustee.Domain = $Null
		    #$Trustee.SID = ([wmi]"win32_userAccount.Domain='york.edu',Name='$name'").sid   
		    $ace.AccessMask = 1179817
		    $ace.AceFlags = 3
		    $ace.AceType = 0
		    $ACE.Trustee = $Trustee 
		    $sd.DACL += $ACE.psObject.baseobject        

		    $mc = [WmiClass]"Win32_Share"
		    $InParams = $mc.psbase.GetMethodParameters($Method)
		    $InParams.Access = $sd
		    $InParams.Description = $description
		    $InParams.MaximumAllowed = $Null
		    $InParams.Name = $name
		    $InParams.Password = $Null
		    $InParams.Path = $path
		    $InParams.Type = [uint32]0

		    $R = $mc.PSBase.InvokeMethod($Method, $InParams, $Null)
		    switch ($($R.ReturnValue))
		     {
		          0 {Write-Host "Share:$name Path:$path Result:Success"; break}
		          2 {Write-Host "Share:$name Path:$path Result:Access Denied" -foregroundcolor red -backgroundcolor yellow;break}
		          8 {Write-Host "Share:$name Path:$path Result:Unknown Failure" -foregroundcolor red -backgroundcolor yellow;break}
		          9 {Write-Host "Share:$name Path:$path Result:Invalid Name" -foregroundcolor red -backgroundcolor yellow;break}
		          10 {Write-Host "Share:$name Path:$path Result:Invalid Level" -foregroundcolor red -backgroundcolor yellow;break}
		          21 {Write-Host "Share:$name Path:$path Result:Invalid Parameter" -foregroundcolor red -backgroundcolor yellow;break}
		          22 {Write-Host "Share:$name Path:$path Result:Duplicate Share" -foregroundcolor red -backgroundcolor yellow;break}
		          23 {Write-Host "Share:$name Path:$path Result:Reedirected Path" -foregroundcolor red -backgroundcolor yellow;break}
		          24 {Write-Host "Share:$name Path:$path Result:Unknown Device or Directory" -foregroundcolor red -backgroundcolor yellow;break}
		          25 {Write-Host "Share:$name Path:$path Result:Network Name Not Found" -foregroundcolor red -backgroundcolor yellow;break}
		          default {Write-Host "Share:$name Path:$path Result:*** Unknown Error ***" -foregroundcolor red -backgroundcolor yellow;break}
		     }
	}
	ELSEIF ($name -eq "IISLogs$")
	{
			#Share with Administrators
		    $ACE = ([WMIClass] "Win32_ACE").CreateInstance()
		    $Trustee = ([WMIClass] "Win32_Trustee").CreateInstance()
		    $Trustee.Name = "Administrators"
		    $Trustee.Domain = $Null
		    #$Trustee.SID = ([wmi]"win32_userAccount.Domain='york.edu',Name='$name'").sid   
		    $ace.AccessMask = 2032127
		    $ace.AceFlags = 3
		    $ace.AceType = 0
		    $ACE.Trustee = $Trustee 
		    $sd.DACL += $ACE.psObject.baseobject 
			
			#Share with ASP SDE Users
		    $ACE = ([WMIClass] "Win32_ACE").CreateInstance()
		    $Trustee = ([WMIClass] "Win32_Trustee").CreateInstance()
		    $Trustee.Name = "$strDomain\ASP SDE Users"
		    $Trustee.Domain = $Null
		    #$Trustee.SID = ([wmi]"win32_userAccount.Domain='york.edu',Name='$name'").sid   
		    $ace.AccessMask = 1179817
		    $ace.AceFlags = 3
		    $ace.AceType = 0
		    $ACE.Trustee = $Trustee 
		    $sd.DACL += $ACE.psObject.baseobject 

		    $mc = [WmiClass]"Win32_Share"
		    $InParams = $mc.psbase.GetMethodParameters($Method)
		    $InParams.Access = $sd
		    $InParams.Description = $description
		    $InParams.MaximumAllowed = $Null
		    $InParams.Name = $name
		    $InParams.Password = $Null
		    $InParams.Path = $path
		    $InParams.Type = [uint32]0

		    $R = $mc.PSBase.InvokeMethod($Method, $InParams, $Null)
		    switch ($($R.ReturnValue))
		     {
		          0 {Write-Host "Share:$name Path:$path Result:Success"; break}
		          2 {Write-Host "Share:$name Path:$path Result:Access Denied" -foregroundcolor red -backgroundcolor yellow;break}
		          8 {Write-Host "Share:$name Path:$path Result:Unknown Failure" -foregroundcolor red -backgroundcolor yellow;break}
		          9 {Write-Host "Share:$name Path:$path Result:Invalid Name" -foregroundcolor red -backgroundcolor yellow;break}
		          10 {Write-Host "Share:$name Path:$path Result:Invalid Level" -foregroundcolor red -backgroundcolor yellow;break}
		          21 {Write-Host "Share:$name Path:$path Result:Invalid Parameter" -foregroundcolor red -backgroundcolor yellow;break}
		          22 {Write-Host "Share:$name Path:$path Result:Duplicate Share" -foregroundcolor red -backgroundcolor yellow;break}
		          23 {Write-Host "Share:$name Path:$path Result:Reedirected Path" -foregroundcolor red -backgroundcolor yellow;break}
		          24 {Write-Host "Share:$name Path:$path Result:Unknown Device or Directory" -foregroundcolor red -backgroundcolor yellow;break}
		          25 {Write-Host "Share:$name Path:$path Result:Network Name Not Found" -foregroundcolor red -backgroundcolor yellow;break}
		          default {Write-Host "Share:$name Path:$path Result:*** Unknown Error ***" -foregroundcolor red -backgroundcolor yellow;break}
		     }
	
	
	}
}

Function InstallWSUS{
		$AppDesc = "WSUS 3.0 SP2 setup on SUP Role"
		$Monexe = "WSUS30-KB972455-x64"
		If (!(Test-Path -path D:\Storage\WSUS\))
		      
			 {
			    New-Item D:\Storage\WSUS\ -type directory
			    CopyWSUSCode{}

				& $WSUSexe /q $WSUSSparam1 $WSUSSparam2 $WSUSSparam3 $WSUSSparam4 $WSUSSparam5
				CountDown{}
			  	
			  
			 }
		ELSE
			{
			 $ChkFile = "D:\Storage\WSUS\WSUS30-KB972455-x64.exe" 
			 $FileExists = (Test-Path $ChkFile -PathType Leaf)
			 If (!($FileExists)) 
				{
			  			CopyWSUSCode{}

						& $WSUSexe /q $WSUSSparam1 $WSUSSparam2 $WSUSSparam3 $WSUSSparam4 $WSUSSparam5
						CountDown{}
				  	
					
				}
				ElseIf ($FileExists)
				{

						& $WSUSexe /q $WSUSSparam1 $WSUSSparam2 $WSUSSparam3 $WSUSSparam4 $WSUSSparam5
						CountDown{}
						  	
				}
			}
		}

Function InstallWSUSKB2720211{
		$AppDesc = "WSUS 3.0 SP2 KB2720211 Hotfix...."
		$Monexe = "WSUS-KB2720211-x64.exe"
		 $ChkFile = "D:\Storage\WSUS\WSUS-KB2720211-x64.exe" 
		 $FileExists = (Test-Path $ChkFile -PathType Leaf)
		 If (!($FileExists)) 
			{
		  			CopyWSUSCode{}
					Write-Host "Stopping IIS..." -ForegroundColor Yellow
					iisreset /stop
					Write-Host "Stopping WSUSService..." -ForegroundColor Yellow
					net stop wsusservice
					Write-Host "Applying $AppDesc" -ForegroundColor Yellow
					Start-Process -FilePath $WSUSKB2720211exe -ArgumentList /q -Wait
					  	
				
			}
			ElseIf ($FileExists)
			{

					Write-Host "Stopping IIS..." -ForegroundColor Yellow
					iisreset /stop
					Write-Host "Stopping WSUSService..." -ForegroundColor Yellow
					net stop wsusservice
					Write-Host "Applying $AppDesc" -ForegroundColor Yellow
					Start-Process -FilePath $WSUSKB2720211exe -ArgumentList /q -Wait
					  	
			}


		}

Function InstallWSUSKB2734608{
		$AppDesc = "WSUS 3.0 SP2 KB2734608 Hottix...."
		$Monexe = "WSUS-KB2734608-x64.exe"
		 $ChkFile = "D:\Storage\WSUS\WSUS-KB2734608-x64.exe" 
		 $FileExists = (Test-Path $ChkFile -PathType Leaf)
		 If (!($FileExists)) 
			{
		  			CopyWSUSCode{}
					Write-Host "Stopping IIS..." -ForegroundColor Yellow
					iisreset /stop
					Write-Host "Stopping WSUSService..." -ForegroundColor Yellow
					net stop wsusservice
					Write-Host "Applying $AppDesc" -ForegroundColor Yellow
					Start-Process -FilePath $WSUSKB2734608exe -ArgumentList /q -Wait
					  	
				
			}
			ElseIf ($FileExists)
			{

					Write-Host "Stopping IIS..." -ForegroundColor Yellow
					iisreset /stop
					Write-Host "Stopping WSUSService..." -ForegroundColor Yellow
					net stop wsusservice
					Write-Host "Applying $AppDesc" -ForegroundColor Yellow
					Start-Process -FilePath $WSUSKB2734608exe -ArgumentList /q -Wait
					  	
			}


		}

Function NoSMSOnDrive{
		Write-Host -noNewLine "Creating no_sms_on_drive.sms file on C..." -foregroundcolor Yellow
		LogWrite "Dropping no_sms_on_drive.sms file in C drive..."
		New-Item c:\no_sms_on_drive.sms -type file
		Write-Host "Done.." -foregroundcolor green
		
}

Function MoveWSUSIISLogs{
		LogWrite "Configuring WSUS IIS Settings..."
		Write-Host "Configuring WSUS IIS Log settings..." -ForegroundColor Yellow
		Write-Host "Stopping IIS..." -ForegroundColor Yellow
		IIsreset /stop
		#New-Item D:\IIS -type directory
		#Copy-Item C:\inetpub\* D:\IIS -recurse

		Import-Module WebAdministration
		Set-ItemProperty 'IIS:\Sites\WSUS Administration' -name logfile.directory "D:\IIS\Logs"
		Set-ItemProperty 'IIS:\Sites\WSUS Administration' -name logfile.localTimeRollover true
		Set-ItemProperty 'IIS:\Sites\WSUS Administration' -name logfile.period 0
		Set-ItemProperty 'IIS:\Sites\WSUS Administration' -name logfile.truncateSize 5242880
		Write-Host "Starting IIS..." -ForegroundColor Yellow
		IIsreset /start
		Write-Host "Configuring WSUS IIS Log settings... DONE..." -ForegroundColor Green
		LogWrite "WSUS WSUS IIS Settings completed..."

}



Function InstallADKStuff{
		If (!(Test-Path -path D:\Storage\ADK\))
		      
			 {
			  New-Item D:\Storage\ADK\ -type directory
			  Write-Host "Copying ADK setup files..." -ForegroundColor Yellow
			  LogWrite "Copying ADK setup files..."
			  copy-item -Path $strADKLocation -Destination 'D:\storage\ADK'
			  
			  ADKSetup{}
			 }
		ELSE
			{
			 $ChkFile = "D:\Storage\ADK\Windows PE x86 x64-x86_en-us.msi" 
			 $FileExists = (Test-Path $ChkFile -PathType Leaf)
			 If (!($FileExists)) 
				{
				    Write-Host "Copying ADK setup files..." -ForegroundColor Yellow
				    copy-item -Path $strADKLocation -Destination 'D:\storage\ADK'
						    
					ADKSetup{}
					
				}
				ElseIf ($FileExists)
				{
				    
					ADKSetup{}
				}
			}
		Write-Host "ADK setup is Complete..." -ForegroundColor Green
		}

Function ADKSetup{
		
		Write-Host "Installing ADK setup files... Please wait...." -ForegroundColor Yellow
		LogWrite "Starting ADK Setup..."
		$msi = @("D:\Storage\ADK\User State Migration Tool-x86_en-us.msi", "D:\Storage\ADK\Windows Deployment Tools-x86_en-us.msi", "D:\Storage\ADK\Windows PE x86 x64-x86_en-us.msi")
		foreach($_ in $msi)
		#{Start-Process -FilePath msiexec -ArgumentList /i, $_, /quiet -Wait}
		{msiexec /i $_ /quiet | out-null}
		LogWrite "ADK Setup is Completed..."

}

Function InstallSTDSQL{
		If (!(Test-Path -path D:\Storage\SQL12STD\))
		      
			 {
			  New-Item D:\Storage\SQL12STD\ -type directory
			  Write-Host "Copying SQL12 STD setup files please wait..." -ForegroundColor Yellow
			  LogWrite "Copying SQL12 to D:\Storage..."
			  copy-item -Path $strSQL12Location -Destination 'D:\storage\SQL12STD' -Recurse
			  Write-Host "Copy is complete..." -ForegroundColor Green
			  
			  If ($ConfirmRole -like "MQ")
			  		{
			  			Write-Host "Starting SQL Install for MP..." -ForegroundColor Yellow
						LogWrite "Starting SQL Install for MP..."
						Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12MPParam -Wait
						LogWrite "SQL Install is Completed..."
			  		}
			  ElseIf ($ConfirmRole -like "SQ")
			  		{
			  			Write-Host "Starting SQL Install for SUP..." -ForegroundColor Yellow
						LogWrite "Starting SQL Install for SUP..."
						Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12SUPParam -Wait
						LogWrite "SQL Install is Completed..."
			  		}			  
	  
			  
			 }
		ELSE
			{
			 $ChkFile = "D:\Storage\SQL12STD\x64\FixSqlRegistryKey_x64.exe" 
			 $FileExists = (Test-Path $ChkFile -PathType Leaf)
			 If (!($FileExists)) 
				{
				    Write-Host "Copying SQL12 STD setup files please wait..." -ForegroundColor Yellow
					LogWrite "Copying SQL12 to D:\Storage..."
				    copy-item -Path $strSQL12Location -Destination 'D:\storage\SQL12STD' -Recurse
					Write-Host "Copy is complete..." -ForegroundColor Green
					
					If ($ConfirmRole -like "MQ")
					  		{
					  			Write-Host "Starting SQL Install for MP..." -ForegroundColor Yellow
								LogWrite "Starting SQL Install for MP..."
								Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12MPParam -Wait
								LogWrite "SQL Install is Completed..."
					  		}
					ElseIf ($ConfirmRole -like "SQ")
					  		{
					  			Write-Host "Starting SQL Install for SUP..." -ForegroundColor Yellow
								LogWrite "Starting SQL Install for SUP..."
								Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12SUPParam -Wait
								LogWrite "SQL Install is Completed..."
					  		}	
					
				}
				ElseIf ($FileExists)
				{
				    
					If ($ConfirmRole -like "MQ")
					  		{
					  			Write-Host "Starting SQL Install for MP..." -ForegroundColor Yellow
								LogWrite "Starting SQL Install for MP..."
								Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12MPParam -Wait
								LogWrite "SQL Install is Completed..."
					  		}
					ElseIf ($ConfirmRole -like "SQ")
					  		{
					  			Write-Host "Starting SQL Install for SUP..." -ForegroundColor Yellow
								LogWrite "Starting SQL Install for SUP..."
								Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12SUPParam -Wait
								LogWrite "SQL Install is Completed..."
					  		}	
				}
			}
		Write-Host "SQL setup is Complete..." -ForegroundColor Green
		LogWrite "SQL setup is Completed..."
}

Function InstallENTSQL{
		Write-Host "NOTE: THIS OPTION REQUIRES A RESTART..." -ForegroundColor yellow
		Write-Host "Install will start in 10 seconds..." -ForegroundColor yellow
		Start-Sleep -Seconds 10
		If (!(Test-Path -path D:\Storage\SQL12ENT\))
		      
			 {
			  New-Item D:\Storage\SQL12ENT\ -type directory
			  Write-Host "Copying SQL12 ENT setup files please wait..." -ForegroundColor Yellow
			  LogWrite "Copying SQL12 to D:\Storage..."
			  copy-item -Path $strsQL12ENTLocation -Destination 'D:\storage\SQL12ENT' -Recurse
			  Write-Host "Copy is complete..." -ForegroundColor Green
			  
			  If ($ConfirmRole -like "PQ")
			  		{
			  			Write-Host "Starting SQL Install for Primary..." -ForegroundColor Yellow
						LogWrite "Starting SQL Install for Primary..."
						Start-Process -FilePath $strSQL12ENTSetup -ArgumentList $strSQL12PParam -Wait
						LogWrite "SQL Install is Completed..."
						SysRestart{}
			  		}
			  Else
			  		{
					  			Write-Host "Invalid Entry..." -ForegroundColor red -BackgroundColor Black
								Start-Sleep -Seconds 5
			  		}			  
	  
			  
			 }
		ELSE
			{
			 $ChkFile = "D:\Storage\SQL12ENT\x64\FixSqlRegistryKey_x64.exe" 
			 $FileExists = (Test-Path $ChkFile -PathType Leaf)
			 If (!($FileExists)) 
				{
				    Write-Host "Copying SQL12 ENT setup files please wait..." -ForegroundColor Yellow
				    LogWrite "Copying SQL12 to D:\Storage..."
					copy-item -Path $strsQL12ENTLocation -Destination 'D:\storage\SQL12ENT' -Recurse
					Write-Host "Copy is complete..." -ForegroundColor Green
					
					If ($ConfirmRole -like "PQ")
					  		{
					  			Write-Host "Starting SQL Install for Primary..." -ForegroundColor Yellow
								LogWrite "Starting SQL Install for Primary..."
								Start-Process -FilePath $strSQL12ENTSetup -ArgumentList $strSQL12PParam -Wait
								LogWrite "SQL Install is Completed..."
								SysRestart{}
					  		}
					Else
					  		{
					  			Write-Host "Invalid Entry..." -ForegroundColor red -BackgroundColor Black
								Start-Sleep -Seconds 5
					  		}	
					
				}
				ElseIf ($FileExists)
				{
				    
					If ($ConfirmRole -like "PQ")
					  		{
					  			Write-Host "Starting SQL Install for Primary..." -ForegroundColor Yellow
								LogWrite "Starting SQL Install for Primary..."
								Start-Process -FilePath $strSQL12ENTSetup -ArgumentList $strSQL12PParam -Wait
								LogWrite "SQL Install is Completed..."
								SysRestart{}
					  		}
					Else
					  		{
					  			Write-Host "Invalid Entry..." -ForegroundColor red -BackgroundColor Black
								Start-Sleep -Seconds 5
					  		}	
				}
			}
		Write-Host "SQL setup is Complete..." -ForegroundColor Green



}



Function AskforSQLSUPInstall{

		$ConfirmSQLSUPInstall = Read-Host "Would you like to Install SQL Server STD 2012? [Y/N]"
		
		If ($ConfirmSQLSUPInstall -like "Y")
			{
				LogWrite "Starting SQL Install for SUP..."
				New-Item D:\Storage\SQL12STD\ -type directory
				Write-Host "Copying SQL12 STD setup files please wait..." -ForegroundColor Yellow
				LogWrite "Copying SQL12 to D:\Storage..."				
				copy-item -Path $strSQL12Location -Destination 'D:\storage\SQL12STD' -Recurse
				Write-Host "Copy is complete..." -ForegroundColor Green
	  			Write-Host "Starting SQL Install for SUP..." -ForegroundColor Yellow
				LogWrite "Starting SQL Install..."
				Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12SUPParam -Wait
				Write-Host "SQL setup is Complete..." -ForegroundColor Green
				LogWrite "Completed SQL Install..."
				AskforWSUSInstall{}
			}
		Else
			{
				Write-Host "CM Prereq for SUP is complete.  Please install SQL Later by running this script again and enter SQ..." -ForegroundColor Green
				Exit
			}

}


Function AskforSQLTopSUPInstall{
		$ConfirmSQLTopSUPInstall = Read-Host "Would you like to Install SQL Server STD 2012? [Y/N]"
		
		If ($ConfirmSQLTopSUPInstall -like "Y")
			{
				LogWrite "Starting SQL Install for Top SUP..."
				New-Item D:\Storage\SQL12STD\ -type directory
				Write-Host "Copying SQL12 STD setup files please wait..." -ForegroundColor Yellow
				LogWrite "Copying SQL12 to D:\Storage..."
				copy-item -Path $strSQL12Location -Destination 'D:\storage\SQL12STD' -Recurse
				Write-Host "Copy is Completed..." -ForegroundColor Green
	  			Write-Host "Starting SQL Install for SUP..." -ForegroundColor Yellow
				Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12TopSUPParam -Wait
				Write-Host "SQL setup is Completed..." -ForegroundColor Green
				LogWrite "Completed SQL Install..."
				AskforWSUSInstall{}
			}
		Else
			{
				LogWrite "Opted not to Install SQL..."
				Write-Host "CM Prereq for SUP is Completed.  Please install SQL Later by running this script again and enter SQ..." -ForegroundColor Green
				Exit
			}
}


Function AskforSQLMPInstall{

		$ConfirmSQLMPInstall = Read-Host "Would you like to Install SQL Server STD 2012? [Y/N]"
		
		If ($ConfirmSQLMPInstall -like "Y")
			{
				LogWrite "Starting SQL for MP Install..."
				New-Item D:\Storage\SQL12STD\ -type directory
				Write-Host "Copying SQL12 STD setup files please wait..." -ForegroundColor Yellow
				LogWrite "Copying SQL12 to D:\Storage..."
				copy-item -Path $strSQL12Location -Destination 'D:\storage\SQL12STD' -Recurse
				Write-Host "Copy is Completed..." -ForegroundColor Green
	  			Write-Host "Starting SQL Install for MP..." -ForegroundColor Yellow
				Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12MPParam -Wait
				Write-Host "SQL setup is Completed..." -ForegroundColor Green
				LogWrite "Completed SQL Install..."
			}
		Else
			{
				LogWrite "Opted not to Install SQL for MP..."
				Write-Host "CM Prereq for MP is Completed.  Please install SQL Later by running this script again and enter MQ..." -ForegroundColor Green
				Exit
			}


}

Function AskforSQLENTInstall{

		$ConfirmSQLENTInstall = Read-Host "Would you like to Install SQL Server ENT 2012? [Y/N]"
		Write-Host "REMINDER: THIS OPTION REQUIRES A RESTART..." -ForegroundColor yellow
		Write-Host "Install will start in 10 seconds..." -ForegroundColor yellow
		Start-Sleep -Seconds 10
		
		If ($ConfirmSQLENTInstall -like "Y")
			{
				LogWrite "Starting SQL Ent Install..."
				New-Item D:\Storage\SQL12ENT\ -type directory
				Write-Host "Copying SQL12 ENT setup files please wait..." -ForegroundColor Yellow
				LogWrite "Copying SQL12 to D:\Storage..."
				copy-item -Path $strSQL12ENTLocation -Destination 'D:\storage\SQL12ENT' -Recurse
				Write-Host "Copy is Completed..." -ForegroundColor Green
	  			Write-Host "Starting SQL ENT Install for Primary..." -ForegroundColor Yellow
				Start-Process -FilePath $strSQL12ENTSetup -ArgumentList $strSQL12PParam -Wait
				Write-Host "SQL setup is Completed..." -ForegroundColor Green
				LogWrite "Completed SQL Ent Install..."
				SysRestart{}
			}
		Else
			{
				LogWrite "Opted not to Install SQL ENT..."
				Write-Host "CM Primary prereq is Completed.  Please install SQL Later by running this script again and enter PQ..." -ForegroundColor Green
				Exit
			}


}


Function AskforWSUSInstall{

		$ConfirmWSUSInstall = Read-Host "Would you like to Install WSUS on this SUP? [Y/N]"
		
		If ($ConfirmWSUSInstall -like "Y")
			{
				LogWrite "Installing WSUS components..."
				InstallWSUS{}
				LogWrite "WSUS install completed..."
				Start-Sleep -Seconds 45
				LogWrite "Installing WSUS KB2734608..."
				InstallWSUSKB2734608{}
				LogWrite "Installing WSUS KB2734608... COMPLETED"
				Start-Sleep -Seconds 30
				LogWrite "Installing WSUS KB2720211... COMPLETED"
				InstallWSUSKB2720211{}
				Start-Sleep -Seconds 30
				Write-Host "WSUS 3.0 SP2 setup on SUP is Completed" -foregroundcolor green
				LogWrite "WSUS 3.0 SP2 setup on SUP is Completed"
				MoveWSUSIISLogs{}
				Write-Host "WSUS setup is complete.  Goodbye!" -ForegroundColor Green
				Exit
				
			}
		Else
			{
				Write-Host "CM Prereq for SUP is complete.  Please install WSUS Later by running this script again and enter X..." -ForegroundColor Green
				Exit
			}


}


Function AskForPrimaryName{

			do{
			    $a="no error"
			    $ConfirmPrimaryName = Read-Host "Enter the Primary Site Server's Name for this Role server? "
				Try
					{

						([adsi]"WinNT://./Administrators,group").Add("WinNT://$strDomain/$ConfirmPrimaryName$,group")

					}
				Catch [system.exception]
					 {
						 Write-host "Not a valid Name!  Try again! " -ForegroundColor Red -BackgroundColor Black
						 #$error
						 $a = "error"
						 Start-sleep -seconds 5
					 }

			}while($a -eq "error")
}

Function SupRoleInstall{

		LogWrite "Installing SUP Prerequisites/Windows Features...."
		Add-WindowsFeature Web-Server
		Add-WindowsFeature NET-Framework
		Add-WindowsFeature Web-WMI
		Add-WindowsFeature Web-Metabase
		Add-WindowsFeature Web-Windows-Auth
		Add-WindowsFeature Web-ASP-NET
		Add-WindowsFeature Web-Http-Redirect
		Add-WindowsFeature Web-Log-Libraries
		Add-WindowsFeature Web-Http-Tracing
		LogWrite "SUP Prerequisites/Windows Features Completed...."
		
		MoveIIS{}
		#CreateShare "D:\IIS\Logs" "IISLogs$"
		Create-FileShare "D:\IIS\Logs" "IISLogs$"

		LogWrite "Configuing Firewall Settings..."
		Write-Host "Adding firewall settings 1433..." -ForegroundColor Yellow
		netsh advfirewall firewall add rule name="SQLServer" dir=in action=allow protocol=TCP localport=1433
		Write-Host "Adding firewall settings 1433... DONE..." -ForegroundColor Green
		LogWrite "Firewall Settings... Completed"


}

Function MPDPRoleInstall{

		LogWrite "Installing MP Prerequisites..."
		Add-WindowsFeature Web-Server
		Add-WindowsFeature NET-Framework
		Add-WindowsFeature BITS
		Add-WindowsFeature RDC
		Add-WindowsFeature Web-ASP-NET
		Add-WindowsFeature Web-WMI
		Add-WindowsFeature Web-Windows-Auth
		Add-WindowsFeature Web-Scripting-Tools
		LogWrite "MP Prerequisites Features are completed..."

		LogWrite "Starting CCMPENG custom configurations..."
		MoveIIS{}
		#CreateShare "D:\IIS\Logs" "IISLogs$"
		Create-FileShare "D:\IIS\Logs" "IISLogs$"
		
		LogWrite "Configuing Firewall Settings..."
		Write-Host "Adding firewall settings 1433..." -ForegroundColor Yellow
		netsh advfirewall firewall add rule name="SQLServer" dir=in action=allow protocol=TCP localport=1433
		Write-Host "Adding firewall settings 1433... DONE..." -ForegroundColor Yellow
		Write-Host "Adding firewall settings 4022..." -ForegroundColor Yellow
		netsh advfirewall firewall add rule name="SQL Service Broker" dir=in action=allow protocol=TCP localport=4022
		Write-Host "Adding firewall settings 4022... DONE..." -ForegroundColor Green
		LogWrite "Firewall Settings... Completed"

}

Function PRIMARYRoleInstall{

		LogWrite "Installing Primary Server's Prerequisites..."
		Add-WindowsFeature NET-Framework
		Add-WindowsFeature RDC		
		LogWrite "Primary Server Prereq Install Completed..."
		
		LogWrite "Configuing Firewall Settings..."
		Write-Host "Adding firewall settings 1433..." -ForegroundColor Yellow
		netsh advfirewall firewall add rule name="SQLServer" dir=in action=allow protocol=TCP localport=1433
		Write-Host "Adding firewall settings 4022..." -ForegroundColor Yellow
		netsh advfirewall firewall add rule name="SQL Service Broker" dir=in action=allow protocol=TCP localport=4022
		Write-Host "Adding firewall settings for WMI group..." -ForegroundColor Yellow
		netsh advfirewall firewall set rule group="Windows Management Instrumentation (WMI)" new enable=yes
		Write-Host "Adding firewall settings 1433, 4022 and WMI group... DONE..." -ForegroundColor Green
		LogWrite "Firewall Settings... Completed"

}

Function SysRestart{

	$ConfirmRestart = Read-Host "Would you like to Restart the System now? [Y/N]"

	If ($ConfirmRestart -like "Y")
		{
				$Seconds = 30
				$Message = "Restarting Now..."

				Clear-Host
				while ($Seconds -ge 1){ 
				        Write-Progress -Activity "System is Restarting in... " -Status "Time Remaining" -SecondsRemaining $Seconds 
						#Write-Output $Seconds    
						Start-Sleep -Seconds 1     
						#Clear-Host
						
					#	} 
					$Seconds -- 
				} 
				Write-Output $Message
				LogWrite "Restarting the system...."
				Start-Sleep -seconds 3
				Restart-Computer
		}
	ELSE
		{
				Write-Host "System must be restarted in order to use SQL...  Please restart when you can... " -ForegroundColor Yellow
				Exit
		}
}


##################################### Log Initialization #######################################

$script:logfile = ".\$strScriptName.log"
$script:Seperator = @"
$("-" * 25)
"@
$script:loginitialized = $false
$script:FileHeader = @"
$seperator
***Script Information***
Filename:  $strScriptName
Ver. $strScriptVersion
Created by:  Jeff Carreon
Last Run:  $strDateRunTime
**************************
"@  



##################################### MAIN #######################################
Clear-Host

$ConfirmInstall = Read-Host "Proceed to prepare CM12 SP1 on Server 2008 R2? [Y/N]"


If ($ConfirmInstall -like "Y")
 
  {
  CheckOS{}
  $ConfirmRole = Read-Host "What do you want to do? 
  C - for CAS Prereqs
  P - for Primary Prereqs
  M - for MP/DP Prereqs
  S - for SUP Prereqs
  T - for Top SUP Prereqs
  X - for WSUS Automated Setup for SUPs
  MQ - for SQL Install on MP/DP
  SQ - for SQL Install on SUP
  TQ - for SQL Install on Top SUP
  PQ - for SQL Install on Primary (Requires a System Restart)
  CQ - for SQL Install on CAS (Requires a System Restart)
  [C/P/M/S/T/X/MQ/SQ/TQ/PQ/CQ] "
	If ($ConfirmRole -like "M")

		{
			LogWrite "Starting MP Prereq Install..."
			Write-Host "Installing MP/DP Required Features..." -ForegroundColor Yellow
			Import-module servermanager
			
			AskForPrimaryName{}
			CreateStorage{}
			
			MPDPRoleInstall{}
			
			NoSMSOnDrive{}
			AskforSQLMPInstall{}
				
		}
	ElseIf ($ConfirmRole -like "S")

		{
			Write-Host "Installing SUP Required Features..." -ForegroundColor Yellow
			LogWrite "Starting SUP Prereq Install..."
			Import-module servermanager
			AskForPrimaryName{}
			CreateStorage{}
			SupRoleInstall{}
		
			$scriptpath = $MyInvocation.MyCommand.Path
			$dir = Split-Path $scriptpath
			Set-Location $dir
			PrepWSUS{}
			InstallDOTNET{}
			NoSMSOnDrive{}
			AskforSQLSUPInstall{}
		
		}
		
	ElseIf ($ConfirmRole -like "T")

		{
			Write-Host "Installing Top SUP Required Features..." -ForegroundColor Yellow
			LogWrite "Starting Top SUP Prereq Install..."
			Import-module servermanager
			AskForPrimaryName{}
			CreateStorage{}
			
			SupRoleInstall{}
			
			
			$scriptpath = $MyInvocation.MyCommand.Path
			$dir = Split-Path $scriptpath
			Set-Location $dir
			PrepWSUS{}
			InstallDOTNET{}
			NoSMSOnDrive{}
			AskforSQLSUPInstall{}
		
		}
		
	ElseIf ($ConfirmRole -like "P")
	
		{
			Write-host "Installing Site Server's Required Features..." -ForegroundColor Yellow
			LogWrite "Starting Primary Server Prereq Install..."
			Import-module servermanager
			CreateStorage{}
			
			PRIMARYRoleInstall{}
			CreateCmMPReplicaGroup{}
			CreateCmMPReplica{}
			#CreateShare "S:\ConfigMgr_MPReplica" "ConfigMgr_MPReplica"
			Create-FileShare "S:\ConfigMgr_MPReplica" "ConfigMgr_MPReplica"
			
			$scriptpath = $MyInvocation.MyCommand.Path
			$dir = Split-Path $scriptpath
			Set-Location $dir
			PrepWSUS{}
			InstallDOTNET{}
			NoSMSOnDrive{}
			InstallADKStuff{}
			AskforSQLENTInstall{}
		}	
	ElseIf ($ConfirmRole -like "C")
	
		{
			Write-host "Installing CAS Site Server's Required Features..." -ForegroundColor Yellow
			LogWrite "Starting CAS Server Prereq Install..."
			Import-module servermanager
			CreateStorage{}
			
			PRIMARYRoleInstall{}
			
			$scriptpath = $MyInvocation.MyCommand.Path
			$dir = Split-Path $scriptpath
			Set-Location $dir

			PrepWSUS{}
			InstallDOTNET{}
			NoSMSOnDrive{}
			InstallADKStuff{}
			AskforSQLENTInstall{}
		
		}
	
	ElseIf ($ConfirmRole -like "X")
		{
		    $SQLService = Get-Service -Name MSSQLSERVER
			If ($SQLService.status -ne "Running")
				{
					Write-Host "SQL Must be Installed First...  Please install SQL!"
				}
				Else
				{
					Write-host "WSUS 3.0 SP2 setup on SUP Role..." -ForegroundColor Yellow
					$scriptpath = $MyInvocation.MyCommand.Path
					$dir = Split-Path $scriptpath
					Set-Location $dir
					InstallWSUS{}
					Start-Sleep -Seconds 45
					InstallWSUSKB2734608{}
					Start-Sleep -Seconds 30
					InstallWSUSKB2720211{}
					Start-Sleep -Seconds 30
					Write-Host "WSUS 3.0 SP2 setup on SUP is Completed" -foregroundcolor green
					MoveWSUSIISLogs{}
				}
					
		}	

	ElseIf ($ConfirmRole -like "MQ")		
		{
		    $SQLService = Get-Service -Name MSSQLSERVER
			If ($SQLService.status -ne "Running")
				{
					Write-Host "Installing SQL on MP Role...."
					InstallSTDSQL{}
					#sqlcmd -Q "EXEC master..sp_addsrvrolemember @loginame = N'NT AUTHORITY\SYSTEM', @rolename = N'sysadmin'"
					
				}
				Else
				{
					Write-host "SQL is already Installed..." -ForegroundColor Red -BackgroundColor Black
					

				}
					
		}
		
	ElseIf ($ConfirmRole -like "SQ")		
		{
		    $SQLService = Get-Service -Name MSSQLSERVER
			If ($SQLService.status -ne "Running")
				{
					Write-Host "Installing SQL on SUP Role...."
					InstallSTDSQL{}
					#sqlcmd -Q "EXEC master..sp_addsrvrolemember @loginame = N'NT AUTHORITY\SYSTEM', @rolename = N'sysadmin'"
					
				}
				Else
				{
					Write-host "SQL is already Installed..." -ForegroundColor Red -BackgroundColor Black
					

				}
					
		}
	
	ElseIf ($ConfirmRole -like "PQ")
		{
		    $SQLService = Get-Service -Name MSSQLSERVER
			If ($SQLService.status -ne "Running")
				{
					Write-Host "Installing SQL on Primary...."
					InstallENTSQL{}
					#sqlcmd -Q "EXEC master..sp_addsrvrolemember @loginame = N'NT AUTHORITY\SYSTEM', @rolename = N'sysadmin'"
					
				}
				Else
				{
					Write-host "SQL is already Installed..." -ForegroundColor Red -BackgroundColor Black
					

				}			
		}

	ElseIf ($ConfirmRole -like "TQ")
		{
		    $SQLService = Get-Service -Name MSSQLSERVER
			If ($SQLService.status -ne "Running")
				{
					Write-Host "Installing SQL on Primary...."
					InstallSTDSQL{}
					#sqlcmd -Q "EXEC master..sp_addsrvrolemember @loginame = N'NT AUTHORITY\SYSTEM', @rolename = N'sysadmin'"
					Start-Sleep -Seconds 3
					AskforWSUSInstall{}
					
				}
				Else
				{
					Write-host "SQL is already Installed..." -ForegroundColor Red -BackgroundColor Black
					Start-Sleep -Seconds 3
					AskforWSUSInstall{}

				}			
		}

	ElseIf ($ConfirmRole -like "CQ")
		{
		    $SQLService = Get-Service -Name MSSQLSERVER
			If ($SQLService.status -ne "Running")
				{
					Write-Host "Installing SQL on CAS...."
					InstallENTSQL{}
					#sqlcmd -Q "EXEC master..sp_addsrvrolemember @loginame = N'NT AUTHORITY\SYSTEM', @rolename = N'sysadmin'"
					
				}
				Else
				{
					Write-host "SQL is already Installed..." -ForegroundColor Red -BackgroundColor Black
					

				}			
		}
	
	Else
		{
			Write-host "Not a valid Entry...  Try again."  -ForegroundColor Red -BackgroundColor Black
			Start-Sleep -Seconds 5
			Exit
		}


	Write-Host "CM12 SP1 Prerequisites Installation Complete" -foregroundcolor green
	LogWrite "CM12 SP1 Prerequisites Installation Completed"
	Exit
	}

Else

{
Write-Host "Installation Cancelled" -foregroundcolor yellow
Exit
}

