#CM12 SP1 Server 2012 Prerequisites Install
# Ver. 1.8.2012
#By: Jeff Carreon
#Updated: 10/31/2012
# - LAB
#---------###----------#
#-Installs all CM12 SP1 Prerequisites depending on the role chosen at the prompt
#-For servers with IIS; Moves default IIS site to D, Configures all CCMPENG standard IIS settings, Creates IISLogs$ Share
#-Opens up necessary firewalls (1433 only for MPs/DPs and SUPs. 1433, 4022, and WMI for Primary)
#-Prereqs for Primary servers, automated ADK setups, and Optional SQL12 ENT Install
#-Prereqs for MP/DPs and SUPs, and optional SQL12 STD Install for them
#-Drops nosmsdrive on root
#-For SUPs Post SQL Install; Option to installs WSUS feature and Configures WSUS IIS Log Settings (SQL IS REQUIRED)
#-1.6 - added Logging.  Log is created where the ps1 is being run, locally.
#-1.7 - added individual SQL Install for Top SUP
#-1.8 - added enabling of Windows Auth for MP.  Added ConfigMgr Replica share, ConfigMgr_ReplicaAccess group creation for Primary servers.  And CAS support
# ******* PAY CLOSE ATTENTION TO THE VARIABLES BELOW. CHANGE THEM ACCORDINGLY. ******
# ******* AND MAKE SURE THOSE FILES AND FOLDERS EXIST IN THE $SLocation\Storage$ SHARE, ALONG WITH INI FILES FOR SQL ******



##################################### Setting Variables #######################################
$strDomain = "QA-ENT"
$SLocation = "SDESLABCM05.ent.wfb.bank.qa"
$strScriptName = "CM12SP1-S12PreReqQA-1-8.ps1"
$strScriptVersion = "1.8.2012"

########### Make certain files are available in slocation\storage$ share for each variable below
$strADKLocation = "\\$SLocation\storage$\CM12\3ADK\*.*"
$strSQL12Location = "\\$SLocation\storage$\SQL\12\SQL12STD\*"
$strsQL12ENTLocation = "\\$SLocation\storage$\SQL\12\SQL12ENT\*"
$strDISM = "\\$SLocation\storage$\Windows\S12\sources\sxs"

$strSQL12Setup = "D:\Storage\SQL12STD\Setup.exe"
$strSQL12ENTSetup = "D:\Storage\SQL12ENT\Setup.exe"
$strSQL12MPParam = "/ConfigurationFile=D:\Storage\SQL12STD\MPConfigurationFile.ini"
$strSQL12SUPParam = "/ConfigurationFile=D:\Storage\SQL12STD\SUPConfigurationFile.ini"
$strSQL12TopSUPParam = "/ConfigurationFile=D:\Storage\SQL12STD\TOPSUPConfigurationFile.ini"
$strSQL12PParam = "/ConfigurationFile=D:\Storage\SQL12ENT\PConfigurationFile.ini"
$WSUSSparam1 = "SQL_INSTANCE_NAME=%COMPUTERNAME%"
$WSUSSparam2 = "CONTENT_DIR=D:\WSUS"
$strDateRunTime = (Get-Date)

$ErrorActionPreference= 'silentlycontinue'


##################################### Declaring Functions #######################################


Function LogWrite([string]$info){
	if($loginitialized -eq $false)
		{
		$FileHeader > $logfile
		$script:loginitialized = $True
		}
	$info >> $logfile
}    


Function CheckOS{
		$strOS = [System.Environment]::OSVersion.VersionString
		IF ($strOS -like "Microsoft Windows NT 6.2.9200.0")
		    {
			Write-Host "OS is Microsoft Windows Server 2012..." -ForegroundColor Green
			Write-Host "Proceeding with the install..."
			Start-Sleep -Seconds 3
		    }
		Else
		{
		    
			Write-Host "OS is Not valid. This script is only for Server 2012..." -ForegroundColor Red -BackgroundColor Black
			Write-Host "Please run the R2 Version of this script... Exiting..." -ForegroundColor Red -BackgroundColor Black
			Start-Sleep -Seconds 5
			Exit
		}

}


Function CreateStorage{
		If (!(Test-Path -path D:\Storage\))
		     {
			  New-Item D:\Storage\ -type directory
			 }
}

Function CreateCmMPReplica{
			
	    $a="no error"
	    Try
			{				
				
				If (!(Test-Path -path S:\ConfigMgr_MPReplica\))
				     {
					  Write-Host "Creating ConfigMgr_MPReplica folder..." -ForegroundColor Yellow
					  LogWrite "Creating ConfigMgr_MPReplica folder..."
					  New-Item S:\ConfigMgr_MPReplica\ -type directory
					  Write-Host "Creating ConfigMgr_MPReplica share..." -ForegroundColor Yellow
					  LogWrite "Creating ConfigMgr_MPReplica share..."
					  New-SmbShare -Name ConfigMgr_MPReplica -Path S:\ConfigMgr_MPReplica -Description 'ConfigMgr MP Replica' -FullAccess SYSTEM -ReadAccess ConfigMgr_MPReplicaAccess
					 }
				Else
					{
					  Write-Host "Creating ConfigMgr_MPReplica share..." -ForegroundColor Yellow
					  LogWrite "Creating ConfigMgr_MPReplica share..."
					  New-SmbShare -Name ConfigMgr_MPReplica -Path S:\ConfigMgr_MPReplica -Description 'ConfigMgr MP Replica' -FullAccess SYSTEM -ReadAccess ConfigMgr_MPReplicaAccess					
					 
					}
				Write-Host "Creating ConfigMgr_MPReplica share... COMPLETED" -ForegroundColor Green
				LogWrite "Creating ConfigMgr_MPReplica share... COMPLETED"

			}
		Catch [system.exception]
			 {
				 Write-host "Error Creating the share! " -ForegroundColor Red -BackgroundColor Black
				 LogWrite "Error Creating the share! "
				 #$error
				 $a = "error"
				 
			 }
}

Function CreateCmMPReplicaGroup{

	    $a="no error"
	    Try
			{

				Write-Host "Creating ConfigMgr_MPReplicaAccess group..." -ForegroundColor Yellow
				LogWrite "Creating ConfigMgr_MPReplicaAccess group...."
				$computerName = "."
				$localGroupName = "ConfigMgr_MPReplicaAccess"
				$description = "ConfigMgr MP Replica Access Group"
				  
				If ($computerName -eq "") {$computerName = "$env:computername"}  
				  
				If([ADSI]::Exists("WinNT://$computerName,computer")) {  
				  
				    $computer = [ADSI]"WinNT://$computerName,computer"  
				  
				    $localGroup = $computer.Create("group",$localGroupName)  
				    $localGroup.SetInfo()  
				    $localGroup.description = [string]$description  
				    $localGroup.SetInfo()  
				} 
				Write-Host "Creating ConfigMgr_MPReplicaAccess group... COMPLETED" -ForegroundColor Green
				LogWrite "Creating ConfigMgr_MPReplicaAccess group.... COMPLETED"

			}
		Catch [system.exception]
			 {
				 Write-host "Error Creating the group! " -ForegroundColor Red -BackgroundColor Black
				 LogWrite "Error Creating the group! "
				 #$error
				 $a = "error"
				 
			 }



}

Function MoveIIS{
		
		If (!(Test-Path -path D:\IIS\wwwroot\))
			{
				Write-Host "Configuring IIS settings..." -ForegroundColor Yellow
				Write-Host "Stopping IIS..." -ForegroundColor Yellow
				
				IIsreset /stop
				LogWrite "Configuring and Moving IIS to D drive..."
				New-Item D:\IIS -type directory
				Copy-Item C:\inetpub\* D:\IIS -recurse
				Import-Module WebAdministration
				
				Set-ItemProperty 'IIS:\Sites\Default Web Site' -name physicalPath -value "D:\IIS\wwwroot"
				Set-ItemProperty 'IIS:\Sites\Default Web Site' -name logfile.directory "D:\IIS\Logs"
				Set-ItemProperty 'IIS:\Sites\Default Web Site' -name logfile.localTimeRollover true
				Set-ItemProperty 'IIS:\Sites\Default Web Site' -name logfile.period 0
				Set-ItemProperty 'IIS:\Sites\Default Web Site' -name logfile.truncateSize 5242880
				Write-Host "Starting IIS..." -ForegroundColor Yellow
				IIsreset /start
				LogWrite "Default IIS Configuration Completed..."
				Write-Host "Configuring IIS settings. DONE..." -ForegroundColor Green
			}
		Else
			{
				LogWrite "No need to configure, IIS was already done..."
				Write-Host "IIS is already moved..." -ForegroundColor red -BackgroundColor Black
				Start-Sleep -Seconds 5
			}
}

Function CreateShare($Foldername,$Sharename) 
{
		#
		# $Foldername - The full path to the share
		# $Sharename  - The share name

		  write-host "########## $Sharename ##########"

		  # Check if the path exists
		  IF (!(TEST-PATH $Foldername)) 
			  {
			   # Create folder 
			   NEW-ITEM $Foldername -type Directory
			   write-host "Created $Foldername"
			  }
		 
			  # Create Share but check to make sure it isnt already there
			  If (!(GET-WMIOBJECT Win32_Share | Where-Object -FilterScript {$_.Name -eq $Sharename})) 
			  {
			    # Create share
			    $Shares = [wmiclass]"Win32_Share"
			    $results = $Shares.Create($Foldername,$Sharename,0,$null, "IIS Logs Share")
			    if ($results.returnvalue -eq "0") 
					{
				     # Share created ok
				     write-host "Created $Sharename Share Successfully" -ForegroundColor Green
				    } 
				Else
					{
				     # Error creating share
				     write-host "Failed to create $Sharename Share ERROR:" $results.returnvalue -ForegroundColor Red -BackgroundColor
					}
				  } 
		  ELSE
		  {
			    # Share name already exists
			    write-host "$Sharename already exists"  -ForegroundColor Red -BackgroundColor Black
		  }
}

Function CreateIISLogsShare{
			
	    $a="no error"
	    Try
			{				
				Write-Host "Creating IISLogs$ share..." -ForegroundColor Yellow
				LogWrite "Creating IISLogs$ share..."
				New-SmbShare -Name IISLogs$ -Path D:\IIS\Logs -Description "IIS Logs Share" -FullAccess Administrators -ReadAccess "$strDomain\ASP SDE Users"

				Write-Host "Creating IISLogs$ share... COMPLETED" -ForegroundColor Green
				LogWrite "Creating IISLogs$ share... COMPLETED"
			}
		Catch [system.exception]
			 {
				 Write-host "Error Creating the share! " -ForegroundColor Red -BackgroundColor Black
				 LogWrite "Error Creating the share! "
				 $a = "error"
			 }
}

Function InstallWSUS{

	    $SQLService = Get-Service -Name WsusService
		If ($SQLService.status -ne "Running")
			{
				Write-Host "Installing WSUS Role..." -ForegroundColor Yellow
				LogWrite "Staring WSUS Prereq install..."
				Install-WindowsFeature UpdateServices-Services
				Install-WindowsFeature UpdateServices-DB
				Write-Host "Post Install will start in a second, please wait..." -ForegroundColor Yellow
				Start-Sleep -Seconds 10
				& "C:\Program Files\Update Services\Tools\WsusUtil.exe" postinstall $WSUSSparam1 $WSUSSparam2
				Start-Sleep -Seconds 30
				Install-WindowsFeature UpdateServices-UI
				Write-Host "WSUS Installation is Completed..." -ForegroundColor Green
				LogWrite "WSUS Prereq install is Completed..."
			}
		Else
			{
				LogWrite "WSUS is already installed..."
				Write-host "WSUS is already installed..."  -ForegroundColor Red -BackgroundColor Black
				Start-Sleep -Seconds 3
			}
	
}



Function NoSMSOnDrive{
		Write-Host -noNewLine "Creating no_sms_on_drive.sms file on C..." -foregroundcolor Yellow
		LogWrite "Dropping no_sms_on_drive.sms file in C drive..."
		New-Item c:\no_sms_on_drive.sms -type file
		Write-Host "Done.." -foregroundcolor green
		
}

Function MoveWSUSIISLogs{

				LogWrite "Configuring WSUS IIS Settings..."
				Write-Host "Configuring WSUS IIS Log settings..." -ForegroundColor Yellow
				Write-Host "Stopping IIS..." -ForegroundColor Yellow
				IIsreset /stop

				Import-Module WebAdministration
				Set-ItemProperty 'IIS:\Sites\WSUS Administration' -name logfile.directory "D:\IIS\Logs"
				Set-ItemProperty 'IIS:\Sites\WSUS Administration' -name logfile.localTimeRollover true
				Set-ItemProperty 'IIS:\Sites\WSUS Administration' -name logfile.period 0
				Set-ItemProperty 'IIS:\Sites\WSUS Administration' -name logfile.truncateSize 5242880
				Write-Host "Starting IIS..." -ForegroundColor Yellow
				IIsreset /start
				Write-Host "Configuring WSUS IIS Log settings... DONE..." -ForegroundColor Green
				LogWrite "WSUS WSUS IIS Settings completed..."

}
		
Function InstallADKStuff{
		If (!(Test-Path -path D:\Storage\ADK\))
		      
			 {
			  New-Item D:\Storage\ADK\ -type directory
			  Write-Host "Copying ADK setup files..." -ForegroundColor Yellow
			  LogWrite "Copying ADK setup files..."
			  copy-item -Path $strADKLocation -Destination 'D:\storage\ADK'
			  
			  ADKSetup{}
			 }
		ELSE
			{
			 $ChkFile = "D:\Storage\ADK\Windows PE x86 x64-x86_en-us.msi" 
			 $FileExists = (Test-Path $ChkFile -PathType Leaf)
			 If (!($FileExists)) 
				{
				    Write-Host "Copying ADK setup files..." -ForegroundColor Yellow
				    copy-item -Path $strADKLocation -Destination 'D:\storage\ADK'
						    
					ADKSetup{}
					
				}
				ElseIf ($FileExists)
				{
				    
					ADKSetup{}
				}
			}
		Write-Host "ADK setup is Completed..." -ForegroundColor Green
		
}

Function ADKSetup{
		
		Write-Host "Installing ADK setup files... Please wait...." -ForegroundColor Yellow
		LogWrite "Starting ADK Setup..."
		$msi = @("D:\Storage\ADK\User State Migration Tool-x86_en-us.msi", "D:\Storage\ADK\Windows Deployment Tools-x86_en-us.msi", "D:\Storage\ADK\Windows PE x86 x64-x86_en-us.msi")
		foreach($_ in $msi)
		#{Start-Process -FilePath msiexec -ArgumentList /i, $_, /quiet -Wait}
		{msiexec /i $_ /quiet | out-null}
		LogWrite "ADK Setup is Completed..."

}

Function InstallSTDSQL{
		If (!(Test-Path -path D:\Storage\SQL12STD\))
		      
			 {
			  New-Item D:\Storage\SQL12STD\ -type directory
			  Write-Host "Copying SQL12 STD setup files please wait..." -ForegroundColor Yellow
			  LogWrite "Copying SQL12 to D:\Storage..."
			  copy-item -Path $strSQL12Location -Destination 'D:\storage\SQL12STD' -Recurse
			  Write-Host "Copy is Completed..." -ForegroundColor Green
			  
			  If ($ConfirmRole -like "MQ")
			  		{
			  			Write-Host "Starting SQL Install for MP..." -ForegroundColor Yellow
						LogWrite "Starting SQL Install for MP..."
						Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12MPParam -Wait
						LogWrite "SQL Install is Completed..."
			  		}
			  ElseIf ($ConfirmRole -like "SQ")
			  		{
			  			Write-Host "Starting SQL Install for SUP..." -ForegroundColor Yellow
						LogWrite "Starting SQL Install for SUP..."
						Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12SUPParam -Wait
						LogWrite "SQL Install is Completed..."
			  		}			  
			  ElseIf ($ConfirmRole -like "TQ")
			  		{
			  			Write-Host "Starting SQL Install for Top SUP..." -ForegroundColor Yellow
						LogWrite "Starting SQL Install for SUP..."
						Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12TOPSUPParam -Wait
						LogWrite "SQL Install is Completed..."
			  		}
			  
			 }
		ELSE
			{
			 $ChkFile = "D:\Storage\SQL12STD\x64\FixSqlRegistryKey_x64.exe" 
			 $FileExists = (Test-Path $ChkFile -PathType Leaf)
			 If (!($FileExists)) 
				{
				    Write-Host "Copying SQL12 STD setup files please wait..." -ForegroundColor Yellow
				    LogWrite "Copying SQL12 to D:\Storage..."
					copy-item -Path $strSQL12Location -Destination 'D:\storage\SQL12STD' -Recurse
					Write-Host "Copy is Completed..." -ForegroundColor Green
					
					If ($ConfirmRole -like "MQ")
					  		{
					  			Write-Host "Starting SQL Install for MP..." -ForegroundColor Yellow
								LogWrite "Starting SQL Install for MP..."
								Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12MPParam -Wait
								LogWrite "SQL Install is Completed..."
					  		}
					ElseIf ($ConfirmRole -like "SQ")
					  		{
					  			Write-Host "Starting SQL Install for SUP..." -ForegroundColor Yellow
								LogWrite "Starting SQL Install for SUP..."
								Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12SUPParam -Wait
								LogWrite "SQL Install is Completed..."
					  		}	
					ElseIf ($ConfirmRole -like "TQ")
					  		{
					  			Write-Host "Starting SQL Install for Top SUP..." -ForegroundColor Yellow
								LogWrite "Starting SQL Install for SUP..."
								Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12TOPSUPParam -Wait
								LogWrite "SQL Install is Completed..."
					  		}
					
				}
				ElseIf ($FileExists)
				{
				    
					If ($ConfirmRole -like "MQ")
					  		{
					  			Write-Host "Starting SQL Install for MP..." -ForegroundColor Yellow
								LogWrite "Starting SQL Install for MP..."
								Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12MPParam -Wait
								LogWrite "SQL Install is Completed..."
					  		}
					ElseIf ($ConfirmRole -like "SQ")
					  		{
					  			Write-Host "Starting SQL Install for SUP..." -ForegroundColor Yellow
								LogWrite "Starting SQL Install for SUP..."
								Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12SUPParam -Wait
								LogWrite "SQL Install is Completed..."
					  		}
					  			
					ElseIf ($ConfirmRole -like "TQ")
					  		{
					  			Write-Host "Starting SQL Install for Top SUP..." -ForegroundColor Yellow
								LogWrite "Starting SQL Install for SUP..."
								Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12TOPSUPParam -Wait
								LogWrite "SQL Install is Completed..."
					  		}
				}
			}
		Write-Host "SQL setup is Completed..." -ForegroundColor Green
		LogWrite "SQL setup is Completed..."
}

Function InstallENTSQL{
		Write-Host "NOTE: THIS OPTION REQUIRES A RESTART..." -ForegroundColor yellow
		Write-Host "Install will start in 10 seconds..." -ForegroundColor yellow
		Start-Sleep -Seconds 10
		If (!(Test-Path -path D:\Storage\SQL12ENT\))
		      
			 {
			  New-Item D:\Storage\SQL12ENT\ -type directory
			  Write-Host "Copying SQL12 ENT setup files please wait..." -ForegroundColor Yellow
			  LogWrite "Copying SQL12 to D:\Storage..."
			  copy-item -Path $strsQL12ENTLocation -Destination 'D:\storage\SQL12ENT' -Recurse
			  Write-Host "Copy is Completed..." -ForegroundColor Green
			  
			  If ($ConfirmRole -like "PQ")
			  		{
			  			Write-Host "Starting SQL Install for Primary..." -ForegroundColor Yellow
						LogWrite "Starting SQL Install for Primary..."
						Start-Process -FilePath $strSQL12ENTSetup -ArgumentList $strSQL12PParam -Wait
						LogWrite "SQL Install is Completed..."
						SysRestart{}
			  		}
			  ELSEIF ($ConfirmRole -like "CQ")
			  		{
			  			Write-Host "Starting SQL Install for CAS..." -ForegroundColor Yellow
						LogWrite "Starting SQL Install for CAS..."
						Start-Process -FilePath $strSQL12ENTSetup -ArgumentList $strSQL12PParam -Wait
						LogWrite "SQL Install is Completed..."
						SysRestart{}
			  		}
			  Else
			  		{
					  			Write-Host "Invalid Entry..." -ForegroundColor red -BackgroundColor Black
								Start-Sleep -Seconds 5
			  		}			  
	  
			  
			 }
		ELSE
			{
			 $ChkFile = "D:\Storage\SQL12ENT\x64\FixSqlRegistryKey_x64.exe" 
			 $FileExists = (Test-Path $ChkFile -PathType Leaf)
			 If (!($FileExists)) 
				{
				    Write-Host "Copying SQL12 ENT setup files please wait..." -ForegroundColor Yellow
					LogWrite "Copying SQL12 to D:\Storage..."
				    copy-item -Path $strsQL12ENTLocation -Destination 'D:\storage\SQL12ENT' -Recurse
					Write-Host "Copy is Completed..." -ForegroundColor Green
					
					If ($ConfirmRole -like "PQ")
					  		{
					  			Write-Host "Starting SQL Install for Primary..." -ForegroundColor Yellow
								LogWrite "Starting SQL Install for Primary..."
								Start-Process -FilePath $strSQL12ENTSetup -ArgumentList $strSQL12PParam -Wait
								LogWrite "SQL Install is Completed..."
								SysRestart{}
					  		}
					ELSEIF ($ConfirmRole -like "CQ")
					  		{
					  			Write-Host "Starting SQL Install for CAS..." -ForegroundColor Yellow
								LogWrite "Starting SQL Install for CAS..."
								Start-Process -FilePath $strSQL12ENTSetup -ArgumentList $strSQL12PParam -Wait
								LogWrite "SQL Install is Completed..."
								SysRestart{}
					  		}
					
					Else
					  		{
					  			Write-Host "Invalid Entry..." -ForegroundColor red -BackgroundColor Black
								Start-Sleep -Seconds 5
					  		}	
					
				}
				ElseIf ($FileExists)
				{
				    
					If ($ConfirmRole -like "PQ")
					  		{
					  			Write-Host "Starting SQL Install for Primary..." -ForegroundColor Yellow
								LogWrite "Starting SQL Install for Primary..."
								Start-Process -FilePath $strSQL12ENTSetup -ArgumentList $strSQL12PParam -Wait
								LogWrite "SQL Install is Completed..."
								SysRestart{}
					  		}
					ELSEIF ($ConfirmRole -like "CQ")
					  		{
					  			Write-Host "Starting SQL Install for CAS..." -ForegroundColor Yellow
								LogWrite "Starting SQL Install for CAS..."
								Start-Process -FilePath $strSQL12ENTSetup -ArgumentList $strSQL12PParam -Wait
								LogWrite "SQL Install is Completed..."
								SysRestart{}
					  		}
					Else
					  		{
					  			Write-Host "Invalid Entry..." -ForegroundColor red -BackgroundColor Black
								Start-Sleep -Seconds 5
					  		}	
				}
			}
		Write-Host "SQL setup is Completed..." -ForegroundColor Green



}



Function AskforSQLSUPInstall{

		$ConfirmSQLSUPInstall = Read-Host "Would you like to Install SQL Server STD 2012? [Y/N]"
		
		If ($ConfirmSQLSUPInstall -like "Y")
			{
				LogWrite "Starting SQL Install for SUP..."
				New-Item D:\Storage\SQL12STD\ -type directory
				Write-Host "Copying SQL12 STD setup files please wait..." -ForegroundColor Yellow
				LogWrite "Copying SQL12 to D:\Storage..."
				copy-item -Path $strSQL12Location -Destination 'D:\storage\SQL12STD' -Recurse
				Write-Host "Copy is Completed..." -ForegroundColor Green
	  			Write-Host "Starting SQL Install for SUP..." -ForegroundColor Yellow
				LogWrite "Starting SQL Install..."
				Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12SUPParam -Wait
				Write-Host "SQL setup is Completed..." -ForegroundColor Green
				LogWrite "Completed SQL Install..."
				AskforWSUSInstall{}
			}
		Else
			{
				Write-Host "CM Prereq for SUP is Completed.  Please install SQL Later by running this script again and enter SQ..." -ForegroundColor Green
				Exit
			}

}

Function AskforSQLTopSUPInstall{
		$ConfirmSQLTopSUPInstall = Read-Host "Would you like to Install SQL Server STD 2012? [Y/N]"
		
		If ($ConfirmSQLTopSUPInstall -like "Y")
			{
				LogWrite "Starting SQL Install for Top SUP..."
				New-Item D:\Storage\SQL12STD\ -type directory
				Write-Host "Copying SQL12 STD setup files please wait..." -ForegroundColor Yellow
				LogWrite "Copying SQL12 to D:\Storage..."
				copy-item -Path $strSQL12Location -Destination 'D:\storage\SQL12STD' -Recurse
				Write-Host "Copy is Completed..." -ForegroundColor Green
	  			Write-Host "Starting SQL Install for SUP..." -ForegroundColor Yellow
				Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12TopSUPParam -Wait
				Write-Host "SQL setup is Completed..." -ForegroundColor Green
				LogWrite "Completed SQL Install..."
				AskforWSUSInstall{}
			}
		Else
			{
				LogWrite "Opted not to Install SQL..."
				Write-Host "CM Prereq for SUP is Completed.  Please install SQL Later by running this script again and enter SQ..." -ForegroundColor Green
				Exit
			}
}

Function AskforSQLMPInstall{

		$ConfirmSQLMPInstall = Read-Host "Would you like to Install SQL Server STD 2012? [Y/N]"
		
		If ($ConfirmSQLMPInstall -like "Y")
			{
				LogWrite "Starting SQL for MP Install..."
				New-Item D:\Storage\SQL12STD\ -type directory
				Write-Host "Copying SQL12 STD setup files please wait..." -ForegroundColor Yellow
				LogWrite "Copying SQL12 to D:\Storage..."
				copy-item -Path $strSQL12Location -Destination 'D:\storage\SQL12STD' -Recurse
				Write-Host "Copy is Completed..." -ForegroundColor Green
	  			Write-Host "Starting SQL Install for MP..." -ForegroundColor Yellow
				Start-Process -FilePath $strSQL12Setup -ArgumentList $strSQL12MPParam -Wait
				Write-Host "SQL setup is Completed..." -ForegroundColor Green
				LogWrite "Completed SQL Install..."
			}
		Else
			{
				LogWrite "Opted not to Install SQL for MP..."
				Write-Host "CM Prereq for MP is Completed.  Please install SQL Later by running this script again and enter MQ..." -ForegroundColor Green
				Exit
			}


}

Function AskforSQLENTInstall{

		$ConfirmSQLENTInstall = Read-Host "Would you like to Install SQL Server ENT 2012? [Y/N]"
		Write-Host "REMINDER: THIS OPTION REQUIRES A RESTART..." -ForegroundColor yellow
		Write-Host "Install will start in 10 seconds..." -ForegroundColor yellow
		Start-Sleep -Seconds 10
		
		If ($ConfirmSQLENTInstall -like "Y")
			{
				LogWrite "Starting SQL Ent Install..."
				New-Item D:\Storage\SQL12ENT\ -type directory
				Write-Host "Copying SQL12 ENT setup files please wait..." -ForegroundColor Yellow
				LogWrite "Copying SQL12 to D:\Storage..."
				copy-item -Path $strSQL12ENTLocation -Destination 'D:\storage\SQL12ENT' -Recurse
				Write-Host "Copy is Completed..." -ForegroundColor Green
	  			Write-Host "Starting SQL ENT Install for Primary..." -ForegroundColor Yellow
				Start-Process -FilePath $strSQL12ENTSetup -ArgumentList $strSQL12PParam -Wait
				Write-Host "SQL setup is Completed..." -ForegroundColor Green
				LogWrite "Completed SQL Ent Install..."
				SysRestart{}
			}
		Else
			{
				LogWrite "Opted not to Install SQL ENT..."
				Write-Host "CM prereq is Completed.  Please install SQL Later by running this script again and enter PQ..." -ForegroundColor Green
				Exit
			}


}


Function AskforWSUSInstall{

		$ConfirmWSUSInstall = Read-Host "Would you like to Install WSUS Feature? [Y/N]"
		
		If ($ConfirmWSUSInstall -like "Y")
			{
				LogWrite "Installing WSUS components..."
				InstallWSUS{}
				LogWrite "WSUS install completed..."
				MoveWSUSIISLogs{}
				Write-Host "WSUS Feature setup is completed.  Goodbye!" -ForegroundColor Green
				LogWrite "WSUS Feature setup is completed..."
				Exit
				
			}
		Else
			{
				LogWrite "Otped to install WSUS later... Exiting..."
				Write-Host "CM Prereq for SUP is Completed.  Please install WSUS Later by running this script again and enter X..." -ForegroundColor Green
				Exit
			}


}


Function AskForPrimaryName{

			do{
			    $a="no error"
			    $ConfirmPrimaryName = Read-Host "Enter the Primary Site Server's Name for this Role server? "
				Try
					{

						([adsi]"WinNT://./Administrators,group").Add("WinNT://$strDomain/$ConfirmPrimaryName$,group")

					}
				Catch [system.exception]
					 {
						 Write-host "Not a valid Name!  Try again! " -ForegroundColor Red -BackgroundColor Black
						 #$error
						 $a = "error"
						 Start-sleep -seconds 5
					 }

			}while($a -eq "error")
}

Function SupRoleInstall{

		LogWrite "Installing SUP Prerequisites/Windows Features...."
		dism /online /enable-feature /all /featurename:NetFX3 /source:$strDISM /LimitAccess
		Install-WindowsFeature Web-Server
		Install-WindowsFeature RDC
		Install-WindowsFeature Web-WMI
		Install-WindowsFeature Web-Metabase
		Install-WindowsFeature BITS-IIS-Ext
		Install-WindowsFeature WAS-Process-Model
		Install-WindowsFeature WAS-NET-Environment
		Install-WindowsFeature WAS-Config-APIs
		Install-WindowsFeature NET-Framework-Core
		Install-WindowsFeature NET-HTTP-Activation
		Install-WindowsFeature NET-Non-HTTP-Activ
		LogWrite "SUP Prerequisites/Windows Features Completed...."
		MoveIIS{}
		#CreateShare "D:\IIS\Logs" "IISLogs$"
		CreateIISLogsShare{}
		
		LogWrite "Adding Firewalls' settings...."
		Write-Host "Adding firewall settings 1433..." -ForegroundColor Yellow
		netsh advfirewall firewall add rule name="SQLServer" dir=in action=allow protocol=TCP localport=1433
		Write-Host "Adding firewall settings 1433... DONE..." -ForegroundColor Green
		
		#$scriptpath = $MyInvocation.MyCommand.Path
		#$dir = Split-Path $scriptpath
		#Set-Location $dir
		NoSMSOnDrive{}	
}

Function MPDPRoleInstall{

		LogWrite "Installing MP Prerequisites..."
		dism /online /enable-feature /all /featurename:NetFX3 /source:$strDISM /LimitAccess
		Install-WindowsFeature Web-Server
		Install-WindowsFeature RDC
		Install-WindowsFeature Web-WMI
		Install-WindowsFeature Web-Metabase
		Install-WindowsFeature BITS-IIS-Ext
		Install-WindowsFeature WAS-Process-Model
		Install-WindowsFeature WAS-NET-Environment
		Install-WindowsFeature WAS-Config-APIs
		Install-WindowsFeature NET-Framework-Core
		Install-WindowsFeature NET-HTTP-Activation
		Install-WindowsFeature NET-Non-HTTP-Activ
		Install-WindowsFeature Web-Windows-Auth
		Install-WindowsFeature Web-Scripting-Tools
		Install-WindowsFeature Web-Dyn-Compression
		Install-WindowsFeature Web-ISAPI-Filter
		Install-WindowsFeature Web-Net-Ext45
		Install-WindowsFeature Web-Asp-Net
		Install-WindowsFeature Web-Asp-Net45
		LogWrite "MP Prerequisites Features are completed..."
		LogWrite "Starting CCMPENG custom configurations..."
		MoveIIS{}
		#CreateShare "D:\IIS\Logs" "IISLogs$"
		CreateIISLogsShare{}
		Write-Host "Enabling IIS Default Web Site's Windows Auth..." -ForegroundColor Yellow
		LogWrite "Enabling IIS Default Web Site's Windows Auth..."
		Set-WebConfigurationProperty -filter /system.webServer/security/authentication/windowsAuthentication -name enabled -value true -location "Default Web Site"
		Write-Host "Enabling IIS Default Web Site's Windows Auth...  COMPLETED" -ForegroundColor Green
		LogWrite "Enabling IIS Default Web Site's Windows Auth...  Completed."
		
		LogWrite "CCMPENG custom configurations...  Completed."
		
		LogWrite "Configuing Firewall Settings..."
		Write-Host "Adding firewall settings 1433..." -ForegroundColor Yellow
		netsh advfirewall firewall add rule name="SQLServer" dir=in action=allow protocol=TCP localport=1433
		Write-Host "Adding firewall settings 1433... DONE..." -ForegroundColor Green
		Write-Host "Adding firewall settings 4022..." -ForegroundColor Yellow
		netsh advfirewall firewall add rule name="SQL Service Broker" dir=in action=allow protocol=TCP localport=4022
		Write-Host "Adding firewall settings 4022... DONE..." -ForegroundColor Green
		LogWrite "Firewall Settings... Completed"
}

Function PRIMARYRoleInstall{

		LogWrite "Installing Primary Server's Prerequisites..."
		dism /online /enable-feature /all /featurename:NetFX3 /source:$strDISM /LimitAccess
		Install-WindowsFeature NET-Framework-Core
		Install-WindowsFeature RDC		
		Install-WindowsFeature UpdateServices-API
		Install-WindowsFeature UpdateServices-UI
		LogWrite "Primary Server Prereq Install Completed..."
		
		LogWrite "Adding Firewall settings for 1433, 4022 and WMI..."
		Write-Host "Adding firewall settings 1433..." -ForegroundColor Yellow
		netsh advfirewall firewall add rule name="SQLServer" dir=in action=allow protocol=TCP localport=1433
		Write-Host "Adding firewall settings 4022..." -ForegroundColor Yellow
		netsh advfirewall firewall add rule name="SQL Service Broker" dir=in action=allow protocol=TCP localport=4022
		Write-Host "Adding firewall settings for WMI group..." -ForegroundColor Yellow
		netsh advfirewall firewall set rule group="Windows Management Instrumentation (WMI)" new enable=yes
		Write-Host "Adding firewall settings 1433, 4022 and WMI group... DONE..." -ForegroundColor Green
		LogWrite "Firewall settings Completed"
		

		

}

Function SysRestart{

	$ConfirmRestart = Read-Host "Would you like to Restart the System now? [Y/N]"

	If ($ConfirmRestart -like "Y")
		{
				$Seconds = 30
				$Message = "Restarting Now..."

				clear-host
				while ($Seconds -ge 1){ 
				        Write-Progress -Activity "System is Restarting in... " -Status "Time Remaining" -SecondsRemaining $Seconds 
						#Write-Output $Seconds    
						Start-Sleep -Seconds 1     
						#Clear-Host
						
					#	} 
					$Seconds -- 
				} 
				Write-Output $Message
				LogWrite "Restarting the system...."
				Start-Sleep -seconds 3
				Restart-Computer
		}
	ELSE
		{
				Write-Host "System must be restarted in order to use SQL...  Please restart when you can... " -ForegroundColor Yellow
				Exit
		}
}

##################################### Log Initialization #######################################

$script:logfile = ".\$strScriptName.log"
$script:Seperator = @"
$("-" * 25)
"@
$script:loginitialized = $false
$script:FileHeader = @"
$seperator
***Script Information***
Filename:  $strScriptName
Ver. $strScriptVersion
Created by:  Jeff Carreon
Last Run:  $strDateRunTime
**************************
"@  



##################################### MAIN #######################################
Clear-Host

$ConfirmInstall = Read-Host "Proceed to prepare CM12 SP1 on Server 2012? [Y/N]"


If ($ConfirmInstall -like "Y")
 
  {
  CheckOS{}
  $ConfirmRole = Read-Host "What do you want to do? 
  C - for CAS Prereqs
  P - for Primary Prereqs
  M - for MP/DP Prereqs
  S - for SUP Prereqs
  T - for Top SUP Prereqs
  X - for WSUS Automated Setup for SUPs
  MQ - for SQL Install on MP/DP
  SQ - for SQL Install on SUP
  TQ - for SQL Install on Top SUP
  PQ - for SQL Install on Primary (Requires a System Restart)
  CQ - for SQL Install on CAS (Requires a System Restart)
  [C/P/M/S/T/X/MQ/SQ/TQ/PQ/CQ] "
	If ($ConfirmRole -like "M")

		{
			LogWrite "Starting MP Prereq Install..."
			AskForPrimaryName{}
			Write-Host "Installing MP/DP Required Features..." -ForegroundColor Yellow
			Import-module servermanager
			
			CreateStorage{}
			
			MPDPRoleInstall{}
			
			NoSMSOnDrive{}
			AskforSQLMPInstall{}
		
		}
		
	ElseIf ($ConfirmRole -like "S")

		{
			AskForPrimaryName{}
			Write-Host "Installing SUP Required Features..." -ForegroundColor Yellow
			LogWrite "Starting SUP Prereq Install..."
			Import-module servermanager
			CreateStorage{}
			SupRoleInstall{}
			AskforSQLSUPInstall{}
		
		}
		
	ElseIf ($ConfirmRole -like "T")

		{
			AskForPrimaryName{}
			Write-Host "Installing Top SUP Required Features..." -ForegroundColor Yellow
			LogWrite "Starting Top SUP Prereq Install..."
			Import-module servermanager
			CreateStorage{}
			SupRoleInstall{}
			AskforSQLTopSUPInstall{}
		
		}
		
	ElseIf ($ConfirmRole -like "P")
	
		{
			Write-host "Installing Primary Site Server's Required Features..." -ForegroundColor Yellow
			LogWrite "Starting Primary Server Prereq Install..."
			Import-module servermanager
			CreateStorage{}
			
			PRIMARYRoleInstall{}
			CreateCmMPReplicaGroup{}
			CreateCmMPReplica{}
			$scriptpath = $MyInvocation.MyCommand.Path
			$dir = Split-Path $scriptpath
			Set-Location $dir
			
			NoSMSOnDrive{}
			InstallADKStuff{}
			AskforSQLENTInstall{}
		
		}	

	ElseIf ($ConfirmRole -like "C")
	
		{
			Write-host "Installing CAS Site Server's Required Features..." -ForegroundColor Yellow
			LogWrite "Starting CAS Server Prereq Install..."
			Import-module servermanager
			CreateStorage{}
			
			PRIMARYRoleInstall{}
			
			$scriptpath = $MyInvocation.MyCommand.Path
			$dir = Split-Path $scriptpath
			Set-Location $dir
			
			NoSMSOnDrive{}
			InstallADKStuff{}
			AskforSQLENTInstall{}
		
		}	

	ElseIf ($ConfirmRole -like "X")
		{
		    $SQLService = Get-Service -Name MSSQLSERVER
			If ($SQLService.status -ne "Running")
				{
					Write-Host "SQL Must be Installed First...  Please install SQL!"
				}
				Else
				{
					Write-host "WSUS Install on SUP Role..." -ForegroundColor Yellow
					#Write-host "Granting SA rights to NT Authority\System...." -ForegroundColor Yellow
					#sqlcmd -Q "EXEC master..sp_addsrvrolemember @loginame = N'NT AUTHORITY\SYSTEM', @rolename = N'sysadmin'"
					$scriptpath = $MyInvocation.MyCommand.Path
					$dir = Split-Path $scriptpath
					Set-Location $dir
					InstallWSUS{}
					MoveWSUSIISLogs{}
				}
					
		}	

	ElseIf ($ConfirmRole -like "MQ")		
		{
		    $SQLService = Get-Service -Name MSSQLSERVER
			If ($SQLService.status -ne "Running")
				{
					Write-Host "Installing SQL on MP Role...."
					InstallSTDSQL{}
					#sqlcmd -Q "EXEC master..sp_addsrvrolemember @loginame = N'NT AUTHORITY\SYSTEM', @rolename = N'sysadmin'"
					
				}
				Else
				{
					Write-host "SQL is already Installed..." -ForegroundColor Red -BackgroundColor Black
					

				}
					
		}
		
	ElseIf ($ConfirmRole -like "SQ")		
		{
		    $SQLService = Get-Service -Name MSSQLSERVER
			If ($SQLService.status -ne "Running")
				{
					Write-Host "Installing SQL on SUP Role...."
					InstallSTDSQL{}
					#sqlcmd -Q "EXEC master..sp_addsrvrolemember @loginame = N'NT AUTHORITY\SYSTEM', @rolename = N'sysadmin'"
					
				}
				Else
				{
					Write-host "SQL is already Installed..." -ForegroundColor Red -BackgroundColor Black
					

				}
					
		}
	
	ElseIf ($ConfirmRole -like "PQ")
		{
		    $SQLService = Get-Service -Name MSSQLSERVER
			If ($SQLService.status -ne "Running")
				{
					Write-Host "Installing SQL on Primary...."
					InstallENTSQL{}
					#sqlcmd -Q "EXEC master..sp_addsrvrolemember @loginame = N'NT AUTHORITY\SYSTEM', @rolename = N'sysadmin'"
					
				}
				Else
				{
					Write-host "SQL is already Installed..." -ForegroundColor Red -BackgroundColor Black
					

				}			
		}

	ElseIf ($ConfirmRole -like "TQ")
		{
		    $SQLService = Get-Service -Name MSSQLSERVER
			If ($SQLService.status -ne "Running")
				{
					Write-Host "Installing SQL on Primary...."
					InstallSTDSQL{}
					#sqlcmd -Q "EXEC master..sp_addsrvrolemember @loginame = N'NT AUTHORITY\SYSTEM', @rolename = N'sysadmin'"
					Start-Sleep -Seconds 3
					AskforWSUSInstall{}
					
				}
				Else
				{
					Write-host "SQL is already Installed..." -ForegroundColor Red -BackgroundColor Black
					Start-Sleep -Seconds 3
					AskforWSUSInstall{}

				}			
		}

	ElseIf ($ConfirmRole -like "CQ")
		{
		    $SQLService = Get-Service -Name MSSQLSERVER
			If ($SQLService.status -ne "Running")
				{
					Write-Host "Installing SQL on CAS...."
					InstallENTSQL{}
					#sqlcmd -Q "EXEC master..sp_addsrvrolemember @loginame = N'NT AUTHORITY\SYSTEM', @rolename = N'sysadmin'"
					
				}
				Else
				{
					Write-host "SQL is already Installed..." -ForegroundColor Red -BackgroundColor Black
					

				}			
		}



	Else
		{
			Write-host "Not a valid Entry...  Try again."  -ForegroundColor Red -BackgroundColor Black
			Start-Sleep -Seconds 5
			Exit
		}

	Write-Host "CM12 SP1 Prerequisites Installation Completed" -foregroundcolor green
	LogWrite "CM12 SP1 Prerequisites Installation Completed"
	Exit
	}

Else

{
Write-Host "Installation Cancelled" -foregroundcolor yellow
Exit
}

