﻿#OSD New Machine Import
# .CSV file is required.  See sample.csv for right format


$SiteCode = Read-Host "Enter the site you want to connect to? "
$OsdCsvFilePath = Read-Host "Enter the path and name to the CSV file? "
$ConfirmVMs = Read-Host "Are these VMs [Y/N]?"


$domain = [System.DirectoryServices.ActiveDirectory.Domain]::GetCurrentDomain()

If ($domain -like "jeff.com") # Change this For production
	{
		$strDomain = "JEFF"
		$DeployCollection = "OSD Production Server Deployments" # Change this to match production collection for server deployments
		
	}
Elseif ($domain -like "lab.com") # Change this For your lab
	{
		$strDomain = "LAB"
		$DeployCollection = "OSD Lab Server Deployments" # Change this to match lab collection for server deployments
		
	}
Else
	{
	Write-Host "Unsupported Domain.  Exiting"  -ForegroundColor Red
	Exit
	}



if ([Environment]::Is64BitProcess -eq $True)
	{    Throw "Need to run at a X86 PowershellPrompt"    }
	
# Load ConfigMgr module if it isn't loaded already 
if (-not(Get-Module -name ConfigurationManager)) {
	Import-Module ($Env:SMS_ADMIN_UI_PATH.Substring(0,$Env:SMS_ADMIN_UI_PATH.Length-5) + '\ConfigurationManager.psd1')    
	}   
# Change to site     
	Push-Location    
	Set-Location ${SiteCode}:




$OSDvar = Import-Csv $OsdCsvFilePath

If ($ConfirmVMs -like "Y")
	{
		foreach ($Ovar in $OSDvar)
		{
			$cName = $Ovar.Name
			$cIPAddress = $Ovar.IPAddress
			$cMacAddress = $Ovar.MacAddress
			$cIPMask = $Ovar.IPMask
			$cIPGateway = $Ovar.IPGateway
			$cDNSList = $Ovar.DNS
			$cWINSList = $Ovar.WINS
			$cDomain = $Ovar.Domain
			$cOSDAdapter0Mac = $Ovar.OSDAdapter0Mac
			$cEnableDHCP = $Ovar.EnableDHCP
			$cEnableWINs = $Ovar.EnableWINs
			$cEnableDNSReg = $Ovar.EnableDNSReg
			$cAdapter0Name = $Ovar.Adapter0Name
			$cAdapterCount = $Ovar.AdapterCount

			Write-Host "Importing $cName with MacAddress $cMacAddress to $DeployCollection" -ForegroundColor Green -BackgroundColor Black

			Import-CMComputerInformation -ComputerName $cName -MacAddress $cMacAddress -CollectionName $DeployCollection
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0IPAddressList -VariableValue $cIPAddress -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0SubnetMask -VariableValue $cIPMask -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0Gateways -VariableValue $cIPGateway -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0DNSServerList -VariableValue $cDNSList -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0WINSServerList -VariableValue $cWINSList -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDDomainName -VariableValue $cDomain -IsMask 0 -confirm:$false
			# New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0MacAddress -VariableValue $cOSDAdapter0Mac -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0EnableDHCP -VariableValue $cEnableDHCP -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0EnableWINS -VariableValue $cEnableWINs -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0EnableFullDNSRegistration -VariableValue $cEnableDNSReg -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0Name -VariableValue $cAdapter0Name -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapterCount -VariableValue $cAdapterCount -IsMask 0 -confirm:$false
		}
	}
ELSE
	{
		foreach ($Ovar in $OSDvar)
		{
			$cName = $Ovar.Name
			$cIPAddress = $Ovar.IPAddress
			$cMacAddress = $Ovar.MacAddress
			$cIPMask = $Ovar.IPMask
			$cIPGateway = $Ovar.IPGateway
			$cDNSList = $Ovar.DNS
			$cWINSList = $Ovar.WINS
			$cDomain = $Ovar.Domain
			$cOSDAdapter0Mac = $Ovar.OSDAdapter0Mac
			$cEnableDHCP = $Ovar.EnableDHCP
			$cEnableWINs = $Ovar.EnableWINs
			$cEnableDNSReg = $Ovar.EnableDNSReg
			$cAdapter0Name = $Ovar.Adapter0Name
			$cAdapterCount = $Ovar.AdapterCount
			
			Write-Host "Importing $cName with MacAddress $cMacAddress to $DeployCollection" -ForegroundColor Green -BackgroundColor Black

			Import-CMComputerInformation -ComputerName $cName -MacAddress $cMacAddress -CollectionName $DeployCollection
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0IPAddressList -VariableValue $cIPAddress -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0SubnetMask -VariableValue $cIPMask -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0Gateways -VariableValue $cIPGateway -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0DNSServerList -VariableValue $cDNSList -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0WINSServerList -VariableValue $cWINSList -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDDomainName -VariableValue $cDomain -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0MacAddress -VariableValue $cOSDAdapter0Mac -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0EnableDHCP -VariableValue $cEnableDHCP -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0EnableWINS -VariableValue $cEnableWINs -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0EnableFullDNSRegistration -VariableValue $cEnableDNSReg -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapter0Name -VariableValue $cAdapter0Name -IsMask 0 -confirm:$false
			New-CMDeviceVariable -DeviceName $cName -VariableName OSDAdapterCount -VariableValue $cAdapterCount -IsMask 0 -confirm:$false

			
		}
	}
