﻿##################################### Variables #######################################
$strDateRunTime = (Get-Date)
$strWSUSContent = "R:\WSUSContent" ## <------ Central or shared WSUSContent variable, change this accordingly to which drive your shared WSUSContent is under on the WSUSContent server
$WSUSlocalGroupName = "WSUSContentAccess"  ## <------ Group the gets created on the SUPDB server, where the WSUS Content Share is also created.
$strContentDIR = "D:\WSUS" ## <------ This is the Locally installed WSUS Content on SUPs

####### Setting Domain variables
## <------  Change the $ContentUser and #contentPW .  This account is for setting the virtual content access on the SUPDB.

$domain = [System.DirectoryServices.ActiveDirectory.Domain]::GetCurrentDomain()
If ($domain -like "jeff.com") # Change this For production
	{
		$strDomain = "JEFF"
		$ContentUser = "JEFF\bacon"
		$ContentPW = "eggs"

		
		
	}
Elseif ($domain -like "lab.com") # Change this For your lab
	{
		$strDomain = "LAB"
		$ContentUser = "LAB\bacon"
		$ContentPW = "eggs"
		
	}
Else
	{
	Write-Host "Unsupported Domain.  Exiting"  -ForegroundColor Red
	Exit
	}


##################################### Log Initialization #######################################
$strScriptName = "JInstall-SUPSharedDB.ps1"
$strScriptVersion = "1.0"
$script:logfile = ".\$strScriptName.log"
$script:Seperator = @"
$("-" * 25)
"@
$script:loginitialized = $false
$script:FileHeader = @"
$seperator
***Script Information***
Filename:  $strScriptName
Ver. $strScriptVersion
Created by:  Jeff Carreon
Last Run:  $strDateRunTime
**************************
"@  

##################################### Functions #######################################

Function LogWrite([string]$info){
	if($loginitialized -eq $false)
		{
		$FileHeader > $logfile
		$script:loginitialized = $True
		}
	$info >> $logfile
} 

Function CheckOS{
		$strOS = [System.Environment]::OSVersion.VersionString
		IF ($strOS -like "Microsoft Windows NT 6.2.9200.0")
		    {
			Write-Host "OS is Microsoft Windows Server 2012..." -ForegroundColor Green
			Write-Host "Proceeding with the install..."
			Start-Sleep -Seconds 3
		    }
		ElseIF ($strOS -like "Microsoft Windows NT 6.3.9600.0")
		{
		    
			Write-Host "OS is Microsoft Windows Server 2012 R2..." -ForegroundColor Green
			Write-Host "Proceeding with the install..."
			Start-Sleep -Seconds 3
		    
		}
		Else
		{
			Write-Host "OS is Not valid. This script is only for Server 2012..." -ForegroundColor Red -BackgroundColor Black
			Write-Host "Please run the R2 Version of this script... Exiting..." -ForegroundColor Red -BackgroundColor Black
			Start-Sleep -Seconds 5
			Exit
		}

}

Function CreateWSUSContentShare{
			
	    $a="no error"
	    Try
			{				
				
				If (!(Test-Path -path $strWSUSContent\))
				     {
					  Write-Host "Creating WSUSContent folder..." -ForegroundColor Yellow
					  LogWrite "[$([DateTime]::Now)] Creating WSUSContent folder..."
					  New-Item $strWSUSContent\ -type directory
					  Write-Host "Creating WSUSContent share..." -ForegroundColor Yellow
					  LogWrite "[$([DateTime]::Now)]  Creating WSUSContent share..."
					  New-SmbShare -Name WSUSContent -Path $strWSUSContent -Description 'WSUS Content Share' -FullAccess Administrators -ChangeAccess WSUSContentAccess
					 }
				Else
					{
					  Write-Host "Creating WSUSContent share..." -ForegroundColor Yellow
					  LogWrite "[$([DateTime]::Now)] Creating WSUSContent share..."
					  New-SmbShare -Name WSUSContent -Path $strWSUSContent -Description 'WSUS Content Share' -FullAccess Administrators -ChangeAccess WSUSContentAccess					
					 
					}
				Write-Host "Creating WSUSContent share... COMPLETED" -ForegroundColor Green
				LogWrite "[$([DateTime]::Now)] Creating WSUSContent share... COMPLETED"

			}
		Catch [system.exception]
			 {
				 Write-host "Error Creating the share! " -ForegroundColor Red -BackgroundColor Black
				 LogWrite "[$([DateTime]::Now)] Error Creating the share! "
				 #$error
				 $a = "error"
				 
			 }
}

Function CreateWSUSContentAcessGroup{

	    $a="no error"
	    Try
			{

				Write-Host "Creating WSUSContentAccess group..." -ForegroundColor Yellow
				LogWrite "[$([DateTime]::Now)] Creating WSUSContentAccess group...."
				$computerName = "."
				
				$description = "WSUS Content Access Group"
				  
				If ($computerName -eq "") {$computerName = "$env:computername"}  
				  
				If([ADSI]::Exists("WinNT://$computerName,computer")) {  
				  
				    $computer = [ADSI]"WinNT://$computerName,computer"  
				  
				    $localGroup = $computer.Create("group",$WSUSlocalGroupName)  
				    $localGroup.SetInfo()  
				    $localGroup.description = [string]$description  
				    $localGroup.SetInfo()  
				} 
				Write-Host "Creating WSUSContentAccess group... COMPLETED" -ForegroundColor Green
				LogWrite "[$([DateTime]::Now)] Creating WSUSContentAccess group.... COMPLETED"

			}
		Catch [system.exception]
			 {
				 Write-host "Error Creating the group! " -ForegroundColor Red -BackgroundColor Black
				 LogWrite "[$([DateTime]::Now)] Error Creating the group! "
				 #$error
				 $a = "error"
				 
			 }
}

Function AskForSUPs{

			do{
			    $a="no error"
			    $ConfirmPrimaryName = Read-Host "Enter the Primary Site Server's Name for this Role server? "
				Try
					{

						([adsi]"WinNT://./Administrators,group").Add("WinNT://$strDomain/$ConfirmPrimaryName$,group")

					}
				Catch [system.exception]
					 {
						 Write-host "Not a valid Name!  Try again! " -ForegroundColor Red -BackgroundColor Black
						 #$error
						 $a = "error"
						 Start-sleep -seconds 5
					 }

			}while($a -eq "error")
}


Function InstallSUP1{


		$WSUSService = Get-Service -Name WsusService
		$ConfirmSUPDBName = Read-Host "Enter the SUPDB's Server Name? "
		$WSUSSparam1 = "SQL_INSTANCE_NAME=$ConfirmSUPDBName"
		$WSUSSparam2 = "CONTENT_DIR=$strContentDIR"
		If ($WSUSService.status -eq "Running")
			{
				Write-Host "ReInstalling WSUS DB..." -ForegroundColor Yellow
				LogWrite "[$([DateTime]::Now)] ReInstalling WSUS DB..."
				#Install-WindowsFeature UpdateServices-Services
				Remove-WindowsFeature UpdateServices-DB
				Start-Sleep -Seconds 5
				Install-WindowsFeature UpdateServices-DB
				Write-Host "Post Install will start in a second, please wait..." -ForegroundColor Yellow
				Start-Sleep -Seconds 10
				#$ConfirmSUPDBName = Read-Host "Enter the SUPDB's Server Name? "
				& "C:\Program Files\Update Services\Tools\WsusUtil.exe" postinstall $WSUSSparam1 $WSUSSparam2
				Start-Sleep -Seconds 30
				#Install-WindowsFeature UpdateServices-UI
				Write-Host "Moving WSUS Content to $ConfirmSUPDBName..." -ForegroundColor Green
				& "C:\Program Files\Update Services\Tools\WsusUtil.exe" movecontent \\$ConfirmSUPDBName\WSUSContent SUPMove.log
				Set-WebConfiguration "/system.applicationHost/sites/site[@name='WSUS Administration']/application[@path='/']/VirtualDirectory[@path='/Content']" -Value @{userName=$ContentUser;password=$ContentPW}
				LogWrite "[$([DateTime]::Now)] SUP1 Prep is Completed..."
				
			}
		Else
			{
				Write-Host "ReInstalling WSUS DB..." -ForegroundColor Yellow
				LogWrite "[$([DateTime]::Now)] ReInstalling WSUS DB..."
				Install-WindowsFeature UpdateServices-Services
				#Remove-WindowsFeature UpdateServices-DB
				Start-Sleep -Seconds 5
				Install-WindowsFeature UpdateServices-DB
				Install-WindowsFeature UpdateServices-UI
				Write-Host "Post Install will start in a second, please wait..." -ForegroundColor Yellow
				Start-Sleep -Seconds 10
				#$ConfirmSUPDBName = Read-Host "Enter the SUPDB's Server Name? "
				& "C:\Program Files\Update Services\Tools\WsusUtil.exe" postinstall $WSUSSparam1 $WSUSSparam2
				Start-Sleep -Seconds 30
				#Install-WindowsFeature UpdateServices-UI
				Write-Host "Moving WSUS Content to $ConfirmSUPDBName..." -ForegroundColor Green
				& "C:\Program Files\Update Services\Tools\WsusUtil.exe" movecontent \\$ConfirmSUPDBName\WSUSContent SUPMove.log
				Set-WebConfiguration "/system.applicationHost/sites/site[@name='WSUS Administration']/application[@path='/']/VirtualDirectory[@path='/Content']" -Value @{userName=$ContentUser;password=$ContentPW}
				LogWrite "[$([DateTime]::Now)] SUP1 Prep is Completed..."
			}
		
		try
			{
				$objUser = [ADSI]("WinNT://$strDomain/$env:computername$") 
				$objGroup = [ADSI]("WinNT://$ConfirmSUPDBName/$WSUSlocalGroupName") 
				$objGroup.PSBase.Invoke("Add",$objUser.PSBase.Path)
				LogWrite "[$([DateTime]::Now)] $env:computername added successfully"

			}
		Catch [system.exception]
			{
				LogWrite "[$([DateTime]::Now)] $error"
			}
			
	
}

Function InstallSUPX{


		$WSUSService = Get-Service -Name WsusService
		$ConfirmSUPDBName = Read-Host "Enter the SUPDB's Server Name? "
		$WSUSSparam1 = "SQL_INSTANCE_NAME=$ConfirmSUPDBName"
		$WSUSSparam2 = "CONTENT_DIR=$strContentDIR"
		If ($WSUSService.status -eq "Running")
			{
				Write-Host "ReInstalling WSUS DB..." -ForegroundColor Yellow
				LogWrite "[$([DateTime]::Now)] ReInstalling WSUS DB..."
				#Install-WindowsFeature UpdateServices-Services
				Remove-WindowsFeature UpdateServices-DB
				Start-Sleep -Seconds 5
				Install-WindowsFeature UpdateServices-DB
				Write-Host "Post Install will start in a second, please wait..." -ForegroundColor Yellow
				Start-Sleep -Seconds 10
				#$ConfirmSUPDBName = Read-Host "Enter the SUPDB's Server Name? "
				& "C:\Program Files\Update Services\Tools\WsusUtil.exe" postinstall $WSUSSparam1 $WSUSSparam2
				Start-Sleep -Seconds 30
				#Install-WindowsFeature UpdateServices-UI
				Write-Host "Moving WSUS Content to $ConfirmSUPDBName..." -ForegroundColor Green
				& "C:\Program Files\Update Services\Tools\WsusUtil.exe" movecontent \\$ConfirmSUPDBName\WSUSContent SUPMove.log -skipcopy
				Set-WebConfiguration "/system.applicationHost/sites/site[@name='WSUS Administration']/application[@path='/']/VirtualDirectory[@path='/Content']" -Value @{userName=$ContentUser;password=$ContentPW}
				LogWrite "[$([DateTime]::Now)] SUPX Prep is Completed..."
			}
		Else
			{
				Write-Host "ReInstalling WSUS DB..." -ForegroundColor Yellow
				LogWrite "[$([DateTime]::Now)] ReInstalling WSUS DB..."
				#Install-WindowsFeature UpdateServices-Services
				Remove-WindowsFeature UpdateServices-DB
				Start-Sleep -Seconds 5
				Install-WindowsFeature UpdateServices-DB
				Install-WindowsFeature UpdateServices-UI
				Write-Host "Post Install will start in a second, please wait..." -ForegroundColor Yellow
				Start-Sleep -Seconds 10
				#$ConfirmSUPDBName = Read-Host "Enter the SUPDB's Server Name? "
				& "C:\Program Files\Update Services\Tools\WsusUtil.exe" postinstall $WSUSSparam1 $WSUSSparam2
				Start-Sleep -Seconds 30
				#Install-WindowsFeature UpdateServices-UI
				Write-Host "Moving WSUS Content to $ConfirmSUPDBName..." -ForegroundColor Green
				& "C:\Program Files\Update Services\Tools\WsusUtil.exe" movecontent \\$ConfirmSUPDBName\WSUSContent SUPMove.log -skipcopy
				Set-WebConfiguration "/system.applicationHost/sites/site[@name='WSUS Administration']/application[@path='/']/VirtualDirectory[@path='/Content']" -Value @{userName=$ContentUser;password=$ContentPW}
				LogWrite "[$([DateTime]::Now)] SUPX Prep is Completed..."
			}
		
		try
			{
				$objUser = [ADSI]("WinNT://$strDomain/$env:computername$") 
				$objGroup = [ADSI]("WinNT://$ConfirmSUPDBName/$WSUSlocalGroupName") 
				$objGroup.PSBase.Invoke("Add",$objUser.PSBase.Path)
				LogWrite "[$([DateTime]::Now)] $env:computername added successfully"

			}
		Catch [system.exception]
			{
				LogWrite "[$([DateTime]::Now)] $error"
			}
	
}

##################################### MAIN #######################################
Clear-Host

$ConfirmInstall = Read-Host "Proceed to prepare SUPs with SharedDB on Server 2012/R2? [Y/N]"


If ($ConfirmInstall -like "Y")
 
  {
  CheckOS{}
  $ConfirmRole = Read-Host "What do you want to do? 
  DB - Prep the SUPDB Server
  SUP1 - Prep the first SUP
  SUPX - Prep the next SUP
  [DB/SUP1/SUPX} "
	If ($ConfirmRole -like "DB")

		{
			LogWrite "[$([DateTime]::Now)] Started Preparing SUPDB"
			CreateWSUSContentAcessGroup{}
			CreateWSUSContentShare{}
			Write-Host "SUPDB Preparation is completed..." -ForegroundColor Yellow
			Write-Host "Please ensure the SUPS computernames are entered in WSUSContentAccess Group..." -ForegroundColor Yellow
		
		}
		
	ElseIf ($ConfirmRole -like "SUP1")

		{
			
			Write-Host "Started Preparing SUP1" -ForegroundColor Yellow
			LogWrite "[$([DateTime]::Now)] Preparing SUP1... "
			InstallSUP1{}

		
		}
		
	ElseIf ($ConfirmRole -like "SUPX")

		{
			Write-Host "Started Preparing SUPX" -ForegroundColor Yellow
			LogWrite "[$([DateTime]::Now)] Preparing SUPX... "
			InstallSUPX{}
		
		}
		
	Write-Host "SUPDB Prep Completed" -foregroundcolor green
	LogWrite "[$([DateTime]::Now)] SUPDB Prep Completed "
	Exit
	}

Else

{
Write-Host "Installation Cancelled" -foregroundcolor yellow
Exit
}